/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.config;

import io.helidon.config.Config;
import io.helidon.tracing.config.Traceable;
import java.util.Optional;

public abstract class SpanLogTracingConfig
extends Traceable {
    public static final SpanLogTracingConfig DISABLED = SpanLogTracingConfig.builder("disabled").enabled(false).build();
    public static final SpanLogTracingConfig ENABLED = SpanLogTracingConfig.builder("enabled").build();

    protected SpanLogTracingConfig(String name) {
        super(name);
    }

    static SpanLogTracingConfig merge(final SpanLogTracingConfig older, final SpanLogTracingConfig newer) {
        return new SpanLogTracingConfig(newer.name()){

            @Override
            public Optional<Boolean> isEnabled() {
                return newer.isEnabled().or(older::isEnabled);
            }
        };
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static SpanLogTracingConfig create(String name, Config config) {
        return SpanLogTracingConfig.builder(name).config(config).build();
    }

    public static final class Builder
    implements io.helidon.common.Builder<SpanLogTracingConfig> {
        private final String name;
        private Optional<Boolean> enabled = Optional.empty();

        private Builder(String name) {
            this.name = name;
        }

        public SpanLogTracingConfig build() {
            final Optional<Boolean> finalEnabled = this.enabled;
            return new SpanLogTracingConfig(this.name){

                @Override
                public Optional<Boolean> isEnabled() {
                    return finalEnabled;
                }
            };
        }

        public Builder enabled(boolean enabled) {
            this.enabled = Optional.of(enabled);
            return this;
        }

        public Builder config(Config config) {
            config.get("enabled").asBoolean().ifPresent(this::enabled);
            return this;
        }
    }
}

