/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.media.jsonp;

import io.helidon.common.GenericType;
import io.helidon.common.http.DataChunk;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.ContentReaders;
import io.helidon.media.common.MessageBodyOperator;
import io.helidon.media.common.MessageBodyReader;
import io.helidon.media.common.MessageBodyReaderContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.concurrent.Flow;
import javax.json.JsonException;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonStructure;

final class JsonpBodyReader
implements MessageBodyReader<JsonStructure> {
    private final JsonReaderFactory jsonFactory;

    JsonpBodyReader(JsonReaderFactory jsonFactory) {
        Objects.requireNonNull(jsonFactory);
        this.jsonFactory = jsonFactory;
    }

    public MessageBodyOperator.PredicateResult accept(GenericType<?> type, MessageBodyReaderContext context) {
        return MessageBodyOperator.PredicateResult.supports(JsonStructure.class, type);
    }

    public <U extends JsonStructure> Single<U> read(Flow.Publisher<DataChunk> publisher, GenericType<U> type, MessageBodyReaderContext context) {
        return ContentReaders.readBytes(publisher).map(new BytesToJsonStructure<U>(this.jsonFactory, type, context.charset()));
    }

    private static final class BytesToJsonStructure<T extends JsonStructure>
    implements Mapper<byte[], T> {
        private final JsonReaderFactory jsonFactory;
        private final GenericType<T> type;
        private final Charset charset;

        BytesToJsonStructure(JsonReaderFactory jsonFactory, GenericType<T> type, Charset charset) {
            this.jsonFactory = jsonFactory;
            this.type = type;
            this.charset = charset;
        }

        public T map(byte[] bytes) {
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            JsonReader reader = this.jsonFactory.createReader((InputStream)is, this.charset);
            JsonStructure json = reader.read();
            if (!this.type.rawType().isAssignableFrom(json.getClass())) {
                throw new JsonException("Unable to convert " + String.valueOf(json.getClass()) + " to " + String.valueOf(this.type.rawType()));
            }
            return (T)json;
        }
    }
}

