/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.ConfigHelper;
import io.helidon.config.ConfigKeyImpl;
import io.helidon.config.ConfigSourceRuntime;
import io.helidon.config.ConfigSourceRuntimeImpl;
import io.helidon.config.ConfigSources;
import io.helidon.config.ObjectNodeImpl;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.MergingStrategy;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class ConfigSourcesRuntime {
    private final List<RuntimeWithData> loadedData = new LinkedList<RuntimeWithData>();
    private final List<ConfigSourceRuntimeImpl> allSources;
    private final MergingStrategy mergingStrategy;
    private volatile Consumer<Optional<ConfigNode.ObjectNode>> changeListener;

    ConfigSourcesRuntime(List<ConfigSourceRuntimeImpl> allSources, MergingStrategy mergingStrategy) {
        this.allSources = allSources;
        this.mergingStrategy = mergingStrategy;
    }

    static ConfigSourcesRuntime empty() {
        return new ConfigSourcesRuntime(List.of(new ConfigSourceRuntimeImpl(null, ConfigSources.empty())), MergingStrategy.fallback());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigSourcesRuntime that = (ConfigSourcesRuntime)o;
        return this.allSources.equals(that.allSources);
    }

    public int hashCode() {
        return Objects.hash(this.allSources);
    }

    public String toString() {
        return this.allSources.toString();
    }

    void changeListener(Consumer<Optional<ConfigNode.ObjectNode>> changeListener) {
        this.changeListener = changeListener;
    }

    void startChanges() {
        this.loadedData.stream().filter(loaded -> loaded.runtime().changesSupported()).forEach(loaded -> loaded.runtime().onChange((key, configNode) -> {
            loaded.data(this.processChange(loaded.data, (String)key, (ConfigNode)configNode));
            this.changeListener.accept(this.latest());
        }));
    }

    private Optional<ConfigNode.ObjectNode> processChange(Optional<ConfigNode.ObjectNode> oldData, String changedKey, ConfigNode changeNode) {
        ConfigKeyImpl key = ConfigKeyImpl.of(changedKey);
        ConfigNode.ObjectNode changeObjectNode = this.toObjectNode(changeNode);
        if (key.isRoot()) {
            return Optional.of(changeObjectNode);
        }
        ConfigNode.ObjectNode newRootNode = ConfigNode.ObjectNode.builder().addObject(changedKey, changeObjectNode).build();
        if (oldData.isEmpty()) {
            return Optional.of(newRootNode);
        }
        return Optional.of(this.mergingStrategy.merge(List.of(newRootNode, oldData.get())));
    }

    private ConfigNode.ObjectNode toObjectNode(ConfigNode changeNode) {
        switch (changeNode.nodeType()) {
            case OBJECT: {
                return (ConfigNode.ObjectNode)changeNode;
            }
            case LIST: {
                return ConfigNode.ObjectNode.builder().addList("", (ConfigNode.ListNode)changeNode).build();
            }
            case VALUE: {
                return ConfigNode.ObjectNode.builder().value(((ConfigNode.ValueNode)changeNode).get()).build();
            }
        }
        throw new IllegalArgumentException("Unsupported node type: " + String.valueOf((Object)changeNode.nodeType()));
    }

    synchronized Optional<ConfigNode.ObjectNode> latest() {
        List<ConfigNode.ObjectNode> objectNodes = this.loadedData.stream().map(rec$ -> ((RuntimeWithData)rec$).data()).flatMap(Optional::stream).collect(Collectors.toList());
        return Optional.of(this.mergingStrategy.merge(objectNodes));
    }

    synchronized Optional<ConfigNode.ObjectNode> load() {
        for (ConfigSourceRuntimeImpl configSourceRuntimeImpl : this.allSources) {
            if (configSourceRuntimeImpl.isLazy()) {
                this.loadedData.add(new RuntimeWithData(configSourceRuntimeImpl, Optional.empty()));
                continue;
            }
            this.loadedData.add(new RuntimeWithData(configSourceRuntimeImpl, configSourceRuntimeImpl.load().map(ObjectNodeImpl::wrap).map(objectNode -> objectNode.initDescription(configSourceRuntimeImpl.description()))));
        }
        Set<String> allKeys = this.loadedData.stream().map(rec$ -> ((RuntimeWithData)rec$).data()).flatMap(Optional::stream).flatMap(this::streamKeys).collect(Collectors.toSet());
        if (allKeys.isEmpty()) {
            return Optional.empty();
        }
        for (RuntimeWithData data : this.loadedData) {
            if (!data.runtime().isLazy()) continue;
            data.data(this.loadLazy(data.runtime(), allKeys));
        }
        List<ConfigNode.ObjectNode> list = this.loadedData.stream().map(rec$ -> ((RuntimeWithData)rec$).data()).flatMap(Optional::stream).collect(Collectors.toList());
        return Optional.of(this.mergingStrategy.merge(list));
    }

    private Optional<ConfigNode.ObjectNode> loadLazy(ConfigSourceRuntime runtime, Set<String> allKeys) {
        HashMap<String, ConfigNode> nodes = new HashMap<String, ConfigNode>();
        for (String key : allKeys) {
            runtime.node(key).ifPresent(it -> nodes.put(key, (ConfigNode)it));
        }
        if (nodes.isEmpty()) {
            return Optional.empty();
        }
        ConfigNode.ObjectNode.Builder builder = ConfigNode.ObjectNode.builder();
        nodes.forEach(builder::addNode);
        return Optional.of(builder.build());
    }

    private Stream<String> streamKeys(ConfigNode.ObjectNode objectNode) {
        return ConfigHelper.createFullKeyToNodeMap(objectNode).keySet().stream().map(ConfigKeyImpl::toString);
    }

    private static final class RuntimeWithData {
        private final ConfigSourceRuntimeImpl runtime;
        private Optional<ConfigNode.ObjectNode> data;

        private RuntimeWithData(ConfigSourceRuntimeImpl runtime, Optional<ConfigNode.ObjectNode> data) {
            this.runtime = runtime;
            this.data = data;
        }

        private void data(Optional<ConfigNode.ObjectNode> data) {
            this.data = data;
        }

        private ConfigSourceRuntimeImpl runtime() {
            return this.runtime;
        }

        private Optional<ConfigNode.ObjectNode> data() {
            return this.data;
        }

        public String toString() {
            return this.runtime.toString();
        }
    }
}

