/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.ConfigException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;

class ClasspathSourceHelper {
    private static final Logger LOGGER = Logger.getLogger(ClasspathSourceHelper.class.getName());

    private ClasspathSourceHelper() {
        throw new AssertionError((Object)"Instantiation not allowed.");
    }

    static String uid(String resourceName) {
        try {
            Path resourcePath = ClasspathSourceHelper.resourcePath(resourceName);
            if (resourcePath != null) {
                return resourcePath.toString().replace('\\', '/');
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Not possible to get filesystem path for resource '" + resourceName + "'. Resource's name is used as ConfigSource URI.", ex);
        }
        return resourceName;
    }

    static Path resourcePath(String resourceName) throws URISyntaxException {
        URL resourceUrl = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (resourceUrl != null) {
            URI uri = resourceUrl.toURI();
            if ("file".equals(uri.getScheme())) {
                return Paths.get(uri);
            }
            return null;
        }
        return null;
    }

    static Instant resourceTimestamp(String resourceName) {
        try {
            Path resourcePath = ClasspathSourceHelper.resourcePath(resourceName);
            if (resourcePath != null) {
                return Files.getLastModifiedTime(resourcePath, new LinkOption[0]).toInstant();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Error to get resource '" + resourceName + "' last modified time.", ex);
        }
        return Instant.EPOCH;
    }

    static <T> T content(String resource, String description, BiFunction<InputStream, Instant, T> processor) throws ConfigException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(resource);
        if (inputStream == null) {
            LOGGER.log(Level.FINE, String.format("Error to get %s using %s CONTEXT ClassLoader.", description, classLoader));
            throw new ConfigException(description + " does not exist. Used ClassLoader: " + String.valueOf(classLoader));
        }
        Instant resourceTimestamp = ClasspathSourceHelper.resourceTimestamp(resource);
        try {
            LOGGER.log(Level.FINE, String.format("Getting content from '%s'. Last modified at %s. Used ClassLoader: %s", ClasspathSourceHelper.resourcePath(resource), resourceTimestamp, classLoader));
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Error to get resource '" + resource + "' path. Used ClassLoader: " + String.valueOf(classLoader), ex);
        }
        return processor.apply(inputStream, resourceTimestamp);
    }
}

