/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.mp;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Priority;
import org.eclipse.microprofile.config.spi.ConfigSource;

@Priority(value=400)
class MpSystemPropertiesSource
implements ConfigSource {
    static final int MY_DEFAULT_ORDINAL = 400;
    private final Properties props = System.getProperties();

    MpSystemPropertiesSource() {
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.props.stringPropertyNames());
    }

    public Map<String, String> getProperties() {
        Set<String> strings = this.props.stringPropertyNames();
        HashMap<String, String> result = new HashMap<String, String>();
        strings.forEach(it -> result.put((String)it, this.props.getProperty((String)it)));
        return result;
    }

    public String getValue(String propertyName) {
        return this.props.getProperty(propertyName);
    }

    public String getName() {
        return "System Properties";
    }

    public int getOrdinal() {
        String configOrdinal = this.getValue("config_ordinal");
        if (configOrdinal == null) {
            return 400;
        }
        return super.getOrdinal();
    }

    public String toString() {
        return this.getName() + " (" + this.getOrdinal() + ")";
    }
}

