/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.mp;

import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigValue;
import io.helidon.config.mp.MpConfigSources;
import io.helidon.config.mp.MpMetaConfig;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class MpMetaConfigUtils {
    private static final Logger LOGGER = Logger.getLogger(MpMetaConfig.class.getName());

    private MpMetaConfigUtils() {
    }

    public static List<ConfigSource> sourceFromMeta(Config config, String profile, Function<Path, ConfigSource> fromPath, Function<String, List<ConfigSource>> fromClasspath, BiFunction<String, String, List<ConfigSource>> fromClasspathWithProfile, Function<URL, ConfigSource> fromUrl) {
        String location;
        boolean optional = (Boolean)config.get("optional").asBoolean().orElse((Object)false);
        ConfigException cause = null;
        ConfigValue pathConfig = config.get("path").as(Path.class);
        if (pathConfig.isPresent()) {
            Path path = (Path)pathConfig.get();
            List<ConfigSource> result = MpMetaConfigUtils.sourceFromPathMeta(path, profile, fromPath);
            if (!result.isEmpty()) {
                return result;
            }
            location = "path " + String.valueOf(path.toAbsolutePath());
        } else {
            ConfigValue classpathConfig = config.get("classpath").as(String.class);
            if (classpathConfig.isPresent()) {
                String classpath = (String)classpathConfig.get();
                List<ConfigSource> sources = profile == null ? fromClasspath.apply(classpath) : fromClasspathWithProfile.apply(classpath, profile);
                if (!sources.isEmpty()) {
                    return sources;
                }
                location = "classpath " + classpath;
            } else {
                ConfigValue urlConfig = config.get("url").as(URL.class);
                if (urlConfig.isPresent()) {
                    URL url = (URL)urlConfig.get();
                    List<ConfigSource> sources = null;
                    try {
                        sources = MpMetaConfigUtils.sourceFromUrlMeta(url, profile, fromUrl);
                    }
                    catch (ConfigException e) {
                        cause = e;
                    }
                    if (sources != null && !sources.isEmpty()) {
                        return sources;
                    }
                    location = "url " + String.valueOf(url);
                } else {
                    throw new ConfigException("MP meta configuration does not contain config source location. Node: " + String.valueOf(config.key()));
                }
            }
        }
        if (optional) {
            return List.of();
        }
        String message = "Meta configuration could not find non-optional config source on " + location;
        if (cause == null) {
            throw new ConfigException(message);
        }
        throw new ConfigException(message, (Throwable)cause);
    }

    private static List<ConfigSource> sourceFromUrlMeta(URL url, String profile, Function<URL, ConfigSource> fromUrl) {
        ConfigSource profileSource = null;
        ConfigSource mainSource = null;
        Exception cause = null;
        if (profile != null) {
            try {
                String profileUrl = MpMetaConfigUtils.toProfileName(url.toString(), profile);
                profileSource = fromUrl.apply(new URL(profileUrl));
            }
            catch (Exception e) {
                cause = e;
            }
        }
        try {
            mainSource = fromUrl.apply(url);
            if (cause != null) {
                LOGGER.log(Level.FINEST, "Failed to load profile URL resource, succeeded loading main from " + String.valueOf(url), cause);
            }
        }
        catch (ConfigException e) {
            if (cause != null) {
                e.addSuppressed((Throwable)cause);
                throw e;
            }
            if (profileSource == null) {
                throw e;
            }
            LOGGER.log(Level.FINEST, "Did not find main URL config source from " + String.valueOf(url) + ", have profile source", e);
        }
        return MpMetaConfigUtils.composite(mainSource, profileSource);
    }

    private static List<ConfigSource> sourceFromPathMeta(Path path, String profile, Function<Path, ConfigSource> fromPath) {
        ConfigSource profileSource = null;
        ConfigSource mainSource = null;
        if (profile != null) {
            Path fileNamePath = path.getFileName();
            String fileName = fileNamePath == null ? "" : fileNamePath.toString();
            Path profileSpecific = path.resolveSibling(fileName = MpMetaConfigUtils.toProfileName(fileName, profile));
            if (Files.exists(profileSpecific, new LinkOption[0]) && Files.isRegularFile(profileSpecific, new LinkOption[0])) {
                profileSource = fromPath.apply(profileSpecific);
            }
        }
        if (Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0])) {
            mainSource = fromPath.apply(path);
        }
        return MpMetaConfigUtils.composite(mainSource, profileSource);
    }

    private static List<ConfigSource> composite(ConfigSource mainSource, ConfigSource profileSource) {
        if (profileSource == null) {
            if (mainSource == null) {
                return List.of();
            }
            return List.of(mainSource);
        }
        if (mainSource == null) {
            return List.of(profileSource);
        }
        return List.of(MpConfigSources.composite(profileSource, mainSource));
    }

    private static String toProfileName(String fileName, String profile) {
        int i = fileName.lastIndexOf(46);
        if (i > -1) {
            return fileName.substring(0, i) + "-" + profile + fileName.substring(i);
        }
        return fileName + "-" + profile;
    }
}

