/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.mp;

import io.helidon.config.mp.spi.MpConfigFilter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

@Deprecated(since="2.3.1")
public class MpConfigImpl
implements Config {
    private static final Logger LOGGER = Logger.getLogger(MpConfigImpl.class.getName());
    private static final String REGEX_REFERENCE = "(?<!\\\\)\\$\\{([^}]+)\\}";
    private static final Pattern PATTERN_REFERENCE = Pattern.compile("(?<!\\\\)\\$\\{([^}]+)\\}");
    private static final String REGEX_BACKSLASH = "\\\\(?=\\$\\{([^}]+)\\})";
    private static final Pattern PATTERN_BACKSLASH = Pattern.compile("\\\\(?=\\$\\{([^}]+)\\})");
    private static final ThreadLocal<Set<String>> UNRESOLVED_KEYS = ThreadLocal.withInitial(HashSet::new);
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(?<!\\\\),");
    private static final Pattern ESCAPED_COMMA_PATTERN = Pattern.compile("\\,", 16);
    private static final Map<Class<?>, Class<?>> REPLACED_TYPES = new HashMap();
    private final List<ConfigSource> sources = new LinkedList<ConfigSource>();
    private final HashMap<Class<?>, Converter<?>> converters = new LinkedHashMap();
    private final boolean valueResolving;
    private final List<MpConfigFilter> filters = new ArrayList<MpConfigFilter>();
    private final String configProfile;

    MpConfigImpl(List<ConfigSource> sources, HashMap<Class<?>, Converter<?>> converters, List<MpConfigFilter> filters, String profile) {
        this.sources.addAll(sources);
        this.converters.putAll(converters);
        this.converters.putIfAbsent(String.class, (Converter & Serializable)value -> value);
        this.configProfile = profile;
        this.valueResolving = this.getOptionalValue("helidon.config.value-resolving.enabled", Boolean.class).orElse(true);
        filters.forEach(it -> {
            it.init(this);
            this.filters.add((MpConfigFilter)it);
        });
    }

    public <T> T getValue(String propertyName, Class<T> propertyType) {
        return this.getOptionalValue(propertyName, propertyType).orElseThrow(() -> new NoSuchElementException("Property \"" + propertyName + "\" is not available in configuration"));
    }

    public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
        if (this.configProfile == null) {
            return this.optionalValue(propertyName, propertyType);
        }
        return this.optionalValue("%" + this.configProfile + "." + propertyName, propertyType).or(() -> this.optionalValue(propertyName, propertyType));
    }

    private <T> Optional<T> optionalValue(String propertyName, Class<T> propertyType) {
        if (propertyType.isArray()) {
            Class<?> componentType = propertyType.getComponentType();
            Optional<String> optionalValue = this.getOptionalValue(propertyName, String.class);
            if (optionalValue.isPresent()) {
                return Optional.of(this.toArray(propertyName, optionalValue.get(), componentType));
            }
            String indexedConfigKey = propertyName + ".0";
            optionalValue = this.getOptionalValue(indexedConfigKey, String.class);
            if (optionalValue.isPresent()) {
                LinkedList result = new LinkedList();
                result.add(this.convert(indexedConfigKey, componentType, optionalValue.get()));
                for (int i = 1; i < 1000 && (optionalValue = this.getOptionalValue(indexedConfigKey = propertyName + "." + i, String.class)).isPresent(); ++i) {
                    result.add(this.convert(indexedConfigKey, componentType, optionalValue.get()));
                }
                Object array = Array.newInstance(componentType, result.size());
                for (int i = 0; i < result.size(); ++i) {
                    Object component = result.get(i);
                    Array.set(array, i, component);
                }
                return Optional.of(array);
            }
            return Optional.empty();
        }
        return this.getStringValue(propertyName).flatMap(it -> this.applyFilters(propertyName, (String)it)).map(it -> this.convert(propertyName, propertyType, (String)it));
    }

    public Iterable<String> getPropertyNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (ConfigSource source : this.sources) {
            names.addAll(source.getPropertyNames());
        }
        return names;
    }

    public Iterable<ConfigSource> getConfigSources() {
        return Collections.unmodifiableList(this.sources);
    }

    public <T> T unwrap(Class<T> aClass) {
        if (this.getClass().equals(aClass)) {
            return aClass.cast(this);
        }
        if (aClass.equals(Config.class)) {
            return aClass.cast(this);
        }
        throw new UnsupportedOperationException("Cannot unwrap config into " + aClass.getName());
    }

    public <T> Optional<Converter<T>> getConverter(Class<T> forType) {
        if (forType.isArray()) {
            Class<?> componentType = forType.getComponentType();
            return this.findComponentConverter(componentType).map(it -> this.toArrayConverter(forType, componentType, (Converter<?>)it));
        }
        return this.findComponentConverter(forType);
    }

    private <T> Optional<Converter<T>> findComponentConverter(Class<T> type) {
        Class forType = this.mapType(type);
        return this.converters.entrySet().stream().filter(it -> forType.isAssignableFrom((Class)it.getKey())).findFirst().map(Map.Entry::getValue).map(it -> it).map(it -> (Converter & Serializable)value -> {
            if (value == null) {
                throw new NullPointerException("Null not allowed in MP converters. Converter for type " + forType.getName());
            }
            try {
                return it.convert(value);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot convert value", e);
            }
        }).or(() -> this.findImplicit(forType));
    }

    private <T> Class<T> mapType(Class<T> original) {
        Class<?> aClass = REPLACED_TYPES.get(original);
        return aClass == null ? original : aClass;
    }

    private <T> Converter<T> toArrayConverter(Class<T> type, Class<?> componentType, Converter<?> elementConverter) {
        return (Converter & Serializable)configValue -> {
            if (configValue == null) {
                throw new NullPointerException("Null not allowed in MP converters. Converter for type " + type.getName());
            }
            String[] values = MpConfigImpl.toArray(configValue);
            Object array = Array.newInstance(componentType, values.length);
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                Array.set(array, i, elementConverter.convert(value));
            }
            return type.cast(array);
        };
    }

    private <T> T convert(String propertyName, Class<T> type, String value) {
        try {
            return (T)this.obtainConverter(type).convert(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to convert property \"" + propertyName + "\" from its value \"" + value + "\" to " + type.getName(), e);
        }
    }

    private Optional<String> getStringValue(String propertyName) {
        for (ConfigSource source : this.sources) {
            String value = source.getValue(propertyName);
            if (null == value) continue;
            LOGGER.finest("Found property " + propertyName + " in source " + source.getName());
            return Optional.of(this.resolveReferences(propertyName, value));
        }
        return Optional.empty();
    }

    private Optional<String> applyFilters(String propertyName, String stringValue) {
        String result = stringValue;
        for (MpConfigFilter filter : this.filters) {
            result = filter.apply(propertyName, result);
        }
        return Optional.ofNullable(result);
    }

    private Object toArray(String propertyName, String stringValue, Class<?> componentType) {
        String[] values = MpConfigImpl.toArray(stringValue);
        Object array = Array.newInstance(componentType, values.length);
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            Array.set(array, i, this.convert(propertyName, componentType, value));
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resolveReferences(String key, String value) {
        if (!this.valueResolving) {
            return value;
        }
        if (!UNRESOLVED_KEYS.get().add(key)) {
            UNRESOLVED_KEYS.get().clear();
            throw new IllegalStateException("Recursive resolving of references for key " + key + ", value: " + value);
        }
        try {
            String string = this.format(value);
            return string;
        }
        catch (NoSuchElementException e) {
            LOGGER.log(Level.FINER, e, () -> String.format("Reference for key %s not found. Value: %s", key, value));
            String string = value;
            return string;
        }
        finally {
            UNRESOLVED_KEYS.get().remove(key);
        }
    }

    private String format(String value) {
        Matcher m = PATTERN_REFERENCE.matcher(value);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String propertyName = m.group(1);
            m.appendReplacement(sb, Matcher.quoteReplacement(this.getOptionalValue(propertyName, String.class).orElseGet(() -> "${" + propertyName + "}")));
        }
        m.appendTail(sb);
        m = PATTERN_BACKSLASH.matcher(sb.toString());
        return m.replaceAll("");
    }

    <T> Converter<T> obtainConverter(Class<T> type) {
        return this.getConverter(type).orElseGet(() -> new FailingConverter(type));
    }

    private <T> Optional<Converter<T>> findImplicit(Class<T> type) {
        if (Enum.class.isAssignableFrom(type)) {
            return Optional.of((Converter & Serializable)value -> {
                Class enumClass = type;
                return Enum.valueOf(enumClass, value);
            });
        }
        Optional<Method> method = this.findMethod(type, "of", String.class).or(() -> this.findMethod(type, "valueOf", String.class)).or(() -> this.findMethod(type, "parse", CharSequence.class)).or(() -> this.findMethod(type, "parse", String.class));
        if (method.isPresent()) {
            Method m = method.get();
            return Optional.of((Converter & Serializable)value -> {
                try {
                    return m.invoke(null, value);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to convert to " + type.getName() + " using a static method", e);
                }
            });
        }
        try {
            Constructor constructor = type.getConstructor(String.class);
            if (constructor.canAccess(null)) {
                return Optional.of((Converter & Serializable)value -> {
                    try {
                        return constructor.newInstance(value);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Failed to convert to " + type.getName() + " using a constructor", e);
                    }
                });
            }
            LOGGER.finest("Constructor with String parameter is not accessible on type " + String.valueOf(type));
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(Level.FINEST, "There is no public constructor with string parameter on class " + type.getName(), e);
        }
        return Optional.empty();
    }

    private Optional<Method> findMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        try {
            Method result = type.getDeclaredMethod(name, parameterTypes);
            if (!result.canAccess(null)) {
                LOGGER.finest(() -> "Method " + name + "(" + Arrays.toString(parameterTypes) + ") is not accessible on class " + type.getName());
                return Optional.empty();
            }
            if (!Modifier.isStatic(result.getModifiers())) {
                LOGGER.finest(() -> "Method " + name + "(" + Arrays.toString(parameterTypes) + ") is not static on class " + type.getName());
                return Optional.empty();
            }
            return Optional.of(result);
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(Level.FINEST, "Method " + name + "(" + Arrays.toString(parameterTypes) + ") is not avilable on class " + type.getName(), e);
            return Optional.empty();
        }
    }

    HashMap<Class<?>, Converter<?>> converters() {
        return this.converters;
    }

    static String[] toArray(String stringValue) {
        String[] values = SPLIT_PATTERN.split(stringValue, -1);
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            values[i] = ESCAPED_COMMA_PATTERN.matcher(value).replaceAll(Matcher.quoteReplacement(","));
        }
        return values;
    }

    static {
        REPLACED_TYPES.put(Byte.TYPE, Byte.class);
        REPLACED_TYPES.put(Short.TYPE, Short.class);
        REPLACED_TYPES.put(Integer.TYPE, Integer.class);
        REPLACED_TYPES.put(Long.TYPE, Long.class);
        REPLACED_TYPES.put(Float.TYPE, Float.class);
        REPLACED_TYPES.put(Double.TYPE, Double.class);
        REPLACED_TYPES.put(Boolean.TYPE, Boolean.class);
        REPLACED_TYPES.put(Character.TYPE, Character.class);
    }

    private static class FailingConverter<T>
    implements Converter<T> {
        private final Class<T> type;

        private FailingConverter(Class<T> type) {
            this.type = type;
        }

        public T convert(String value) {
            throw new IllegalArgumentException("Cannot convert \"" + value + "\" to type " + this.type.getName());
        }
    }
}

