/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.config.Config;
import io.helidon.metrics.api.BaseMetricsSettings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class BaseMetricsSettingsImpl
implements BaseMetricsSettings {
    private final boolean isEnabled;
    private final Map<String, Boolean> isBaseMetricEnabled;

    private BaseMetricsSettingsImpl(Builder builder) {
        this.isEnabled = builder.isEnabled;
        this.isBaseMetricEnabled = builder.isBaseMetricEnabled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean isBaseMetricEnabled(String dottedName) {
        return this.isEnabled && this.isBaseMetricEnabled.getOrDefault(dottedName, true) != false;
    }

    @Override
    public Map<String, Boolean> baseMetricEnabledSettings() {
        return Collections.unmodifiableMap(this.isBaseMetricEnabled);
    }

    static class Builder
    implements BaseMetricsSettings.Builder {
        private boolean isEnabled = true;
        private final Map<String, Boolean> isBaseMetricEnabled = new HashMap<String, Boolean>();

        Builder() {
        }

        static Builder create() {
            return new Builder();
        }

        static Builder create(BaseMetricsSettings baseMetricsSettings) {
            Builder result = new Builder();
            result.enabled(baseMetricsSettings.isEnabled());
            baseMetricsSettings.baseMetricEnabledSettings().forEach(result::enableBaseMetric);
            return result;
        }

        public BaseMetricsSettings build() {
            return new BaseMetricsSettingsImpl(this);
        }

        @Override
        public Builder enabled(boolean value) {
            this.isEnabled = value;
            return this;
        }

        @Override
        public Builder config(Config baseMetricsConfig) {
            baseMetricsConfig.get("enabled").asBoolean().ifPresent(this::enabled);
            baseMetricsConfig.detach().asMap().ifPresent(map -> map.forEach((key, value) -> {
                int enabledSuffixStart = key.lastIndexOf(".enabled");
                if (enabledSuffixStart > -1) {
                    String metricName = key.substring(0, enabledSuffixStart);
                    this.enableBaseMetric(metricName, Boolean.parseBoolean(value));
                }
            }));
            return this;
        }

        @Override
        public Builder enableBaseMetric(String dottedName, boolean value) {
            this.isBaseMetricEnabled.put(dottedName, value);
            return this;
        }

        @Override
        public boolean isEnabled() {
            return this.isEnabled;
        }
    }
}

