/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

class SubscriptionArbiter
extends AtomicInteger
implements Flow.Subscription {
    private long requested;
    private Flow.Subscription subscription;
    private final AtomicReference<Flow.Subscription> newSubscription;
    private final AtomicLong newRequested;
    private final AtomicLong newProduced = new AtomicLong();

    protected SubscriptionArbiter() {
        this.newRequested = new AtomicLong();
        this.newSubscription = new AtomicReference();
    }

    @Override
    public void request(long n) {
        SubscriptionHelper.addRequest(this.newRequested, n);
        this.drain();
    }

    @Override
    public void cancel() {
        SubscriptionHelper.cancel(this.newSubscription);
        this.drain();
    }

    protected void setSubscription(Flow.Subscription subscription) {
        Flow.Subscription previous;
        Objects.requireNonNull(subscription, "subscription is null");
        do {
            if ((previous = this.newSubscription.get()) != SubscriptionHelper.CANCELED) continue;
            subscription.cancel();
            return;
        } while (!this.newSubscription.compareAndSet(previous, subscription));
        this.drain();
    }

    protected void produced(long n) {
        SubscriptionHelper.addRequest(this.newProduced, n);
        this.drain();
    }

    final void drain() {
        if (this.getAndIncrement() != 0) {
            return;
        }
        long toRequest = 0L;
        Flow.Subscription requestFrom = null;
        do {
            Flow.Subscription next;
            boolean isCanceled;
            long prod;
            long req;
            if ((req = this.newRequested.get()) != 0L) {
                req = this.newRequested.getAndSet(0L);
            }
            if ((prod = this.newProduced.get()) != 0L) {
                prod = this.newProduced.getAndSet(0L);
            }
            boolean bl = isCanceled = (next = this.newSubscription.get()) == SubscriptionHelper.CANCELED;
            if (next != null) {
                this.newSubscription.compareAndSet(next, null);
            }
            if (isCanceled) {
                Flow.Subscription s = this.subscription;
                this.subscription = null;
                if (s != null) {
                    s.cancel();
                }
                toRequest = 0L;
                requestFrom = null;
                continue;
            }
            long currentRequested = this.requested;
            if (req != 0L) {
                if ((currentRequested += req) < 0L) {
                    currentRequested = Long.MAX_VALUE;
                }
                if ((toRequest += req) < 0L) {
                    toRequest = Long.MAX_VALUE;
                }
                requestFrom = this.subscription;
            }
            if (prod != 0L && currentRequested != Long.MAX_VALUE && (currentRequested -= prod) < 0L) {
                currentRequested = 0L;
            }
            if (next != null) {
                this.subscription = next;
                requestFrom = next;
                toRequest = currentRequested;
            }
            this.requested = currentRequested;
        } while (this.decrementAndGet() != 0);
        if (requestFrom != null && toRequest != 0L) {
            requestFrom.request(toRequest);
        }
    }

    protected final boolean isCanceled() {
        return this.newSubscription.get() == SubscriptionHelper.CANCELED;
    }
}

