/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.CompletionSingle;
import io.helidon.common.reactive.DeferredScalarSubscription;
import io.helidon.common.reactive.Single;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;

final class SingleSwitchIfEmpty<T>
extends CompletionSingle<T> {
    private final Single<T> source;
    private final Single<T> fallback;

    SingleSwitchIfEmpty(Single<T> source, Single<T> fallback) {
        this.source = source;
        this.fallback = fallback;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        this.source.subscribe(new SwitchIfEmptySubscriber<T>(subscriber, this.fallback));
    }

    static final class SwitchIfEmptySubscriber<T>
    extends DeferredScalarSubscription<T>
    implements Flow.Subscriber<T> {
        private final Single<T> fallback;
        private final FallbackSubscriber<T> fallbackSubscriber;
        private Flow.Subscription upstream;
        private boolean nonEmpty;

        SwitchIfEmptySubscriber(Flow.Subscriber<? super T> downstream, Single<T> fallback) {
            super(downstream);
            this.fallback = fallback;
            this.fallbackSubscriber = new FallbackSubscriber(this);
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            this.subscribeSelf();
            subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(T item) {
            this.nonEmpty = true;
            this.complete(item);
        }

        @Override
        public void onError(Throwable throwable) {
            this.error(throwable);
        }

        @Override
        public void onComplete() {
            if (!this.nonEmpty) {
                this.fallback.subscribe(this.fallbackSubscriber);
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.upstream.cancel();
            SubscriptionHelper.cancel(this.fallbackSubscriber);
        }

        static final class FallbackSubscriber<T>
        extends AtomicReference<Flow.Subscription>
        implements Flow.Subscriber<T> {
            private final SwitchIfEmptySubscriber<T> parent;

            FallbackSubscriber(SwitchIfEmptySubscriber<T> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                SubscriptionHelper.setOnce(this, subscription);
                subscription.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(T item) {
                this.parent.complete(item);
            }

            @Override
            public void onError(Throwable throwable) {
                this.parent.error(throwable);
            }

            @Override
            public void onComplete() {
                this.parent.complete();
            }
        }
    }
}

