/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.CompletionSingle;
import io.helidon.common.reactive.DeferredScalarSubscription;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.MultiError;
import io.helidon.common.reactive.Single;
import io.helidon.common.reactive.SingleError;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

final class SingleRetry<T, U>
extends CompletionSingle<T> {
    private final Single<T> source;
    private final BiFunction<? super Throwable, ? super Long, ? extends Flow.Publisher<U>> whenFunction;
    private static final Single<Object> NOW = Single.just(1);

    SingleRetry(Single<T> source, BiFunction<? super Throwable, ? super Long, ? extends Flow.Publisher<U>> whenFunction) {
        this.source = source;
        this.whenFunction = whenFunction;
    }

    SingleRetry(Single<T> source, long count) {
        this(source, SingleRetry.withCount(count));
    }

    SingleRetry(Single<T> source, BiPredicate<? super Throwable, ? super Long> predicate) {
        this(source, SingleRetry.withPredicate(predicate));
    }

    static <U> BiFunction<? super Throwable, ? super Long, ? extends Flow.Publisher<U>> withCount(long count) {
        return (e, n) -> n < count ? NOW : Single.error(e);
    }

    static <U> BiFunction<? super Throwable, ? super Long, ? extends Flow.Publisher<U>> withPredicate(BiPredicate<? super Throwable, ? super Long> predicate) {
        return (e, n) -> predicate.test((Throwable)e, (Long)n) ? NOW : Single.error(e);
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        RetrySubscriber parent = new RetrySubscriber(subscriber, this.whenFunction, this.source);
        subscriber.onSubscribe(parent);
        parent.retry();
    }

    static final class RetrySubscriber<T, U>
    extends DeferredScalarSubscription<T>
    implements Flow.Subscriber<T> {
        private final AtomicInteger wip;
        private final BiFunction<? super Throwable, ? super Long, ? extends Flow.Publisher<U>> whenFunction;
        private final AtomicReference<Flow.Subscription> upstream;
        private final AtomicReference<Flow.Subscription> whenSubscription;
        private final Single<T> source;
        private long count;

        RetrySubscriber(Flow.Subscriber<? super T> downstream, BiFunction<? super Throwable, ? super Long, ? extends Flow.Publisher<U>> whenFunction, Single<T> source) {
            super(downstream);
            this.whenFunction = whenFunction;
            this.upstream = new AtomicReference();
            this.whenSubscription = new AtomicReference();
            this.wip = new AtomicInteger();
            this.source = source;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            if (SubscriptionHelper.setOnce(this.upstream, subscription)) {
                subscription.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T item) {
            this.complete(item);
        }

        @Override
        public void onError(Throwable throwable) {
            Flow.Subscription current = this.upstream.get();
            if (current != SubscriptionHelper.CANCELED && this.upstream.compareAndSet(current, null)) {
                Flow.Publisher<U> when;
                try {
                    when = Objects.requireNonNull(this.whenFunction.apply(throwable, this.count++), "The whenFunction returned a null Flow.Publisher");
                }
                catch (Throwable ex) {
                    if (ex != throwable) {
                        ex.addSuppressed(throwable);
                    }
                    this.error(ex);
                    return;
                }
                if (when == Single.empty() || when == Multi.empty()) {
                    this.complete();
                } else if (when == NOW) {
                    this.retry();
                } else if (when instanceof SingleError) {
                    this.error(((SingleError)when).getError());
                } else if (when instanceof MultiError) {
                    this.error(((MultiError)when).getError());
                } else {
                    when.subscribe(new WhenSubscriber(this));
                }
            }
        }

        @Override
        public void onComplete() {
            this.complete();
        }

        @Override
        public void cancel() {
            super.cancel();
            SubscriptionHelper.cancel(this.upstream);
            SubscriptionHelper.cancel(this.whenSubscription);
        }

        void setWhenSubscription(Flow.Subscription s) {
            SubscriptionHelper.replace(this.whenSubscription, s);
        }

        void retry() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            while (this.upstream.get() != SubscriptionHelper.CANCELED) {
                this.source.subscribe(this);
                if (this.wip.decrementAndGet() != 0) continue;
            }
        }

        static final class WhenSubscriber
        implements Flow.Subscriber<Object> {
            private final RetrySubscriber<?, ?> parent;
            private Flow.Subscription upstream;

            WhenSubscriber(RetrySubscriber<?, ?> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                SubscriptionHelper.validate(this.upstream, subscription);
                this.upstream = subscription;
                this.parent.setWhenSubscription(subscription);
                subscription.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(Object item) {
                this.upstream.cancel();
                this.upstream = SubscriptionHelper.CANCELED;
                this.parent.setWhenSubscription(null);
                this.parent.retry();
            }

            @Override
            public void onError(Throwable throwable) {
                Flow.Subscription s = this.upstream;
                if (s != SubscriptionHelper.CANCELED) {
                    this.upstream = SubscriptionHelper.CANCELED;
                    this.parent.error(throwable);
                }
            }

            @Override
            public void onComplete() {
                Flow.Subscription s = this.upstream;
                if (s != SubscriptionHelper.CANCELED) {
                    this.upstream = SubscriptionHelper.CANCELED;
                    this.parent.complete();
                }
            }
        }
    }
}

