/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.CompletionSingle;
import io.helidon.common.reactive.DeferredScalarSubscription;
import io.helidon.common.reactive.Single;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

final class SingleOnErrorResumeWith<T>
extends CompletionSingle<T> {
    private final Single<T> source;
    private final Function<? super Throwable, ? extends Single<? extends T>> fallbackFunction;

    SingleOnErrorResumeWith(Single<T> source, Function<? super Throwable, ? extends Single<? extends T>> fallbackFunction) {
        this.source = source;
        this.fallbackFunction = fallbackFunction;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber is null");
        this.source.subscribe(new OnErrorResumeWithSubscriber<T>(subscriber, this.fallbackFunction));
    }

    static final class OnErrorResumeWithSubscriber<T>
    extends DeferredScalarSubscription<T>
    implements Flow.Subscriber<T> {
        private final Function<? super Throwable, ? extends Single<? extends T>> fallbackFunction;
        private final FallbackSubscriber<T> fallbackSubscriber;
        private Flow.Subscription upstream;

        OnErrorResumeWithSubscriber(Flow.Subscriber<? super T> downstream, Function<? super Throwable, ? extends Single<? extends T>> fallbackFunction) {
            super(downstream);
            this.fallbackFunction = fallbackFunction;
            this.fallbackSubscriber = new FallbackSubscriber(this);
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            this.subscribeSelf();
            subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(T item) {
            this.upstream = SubscriptionHelper.CANCELED;
            this.complete(item);
        }

        @Override
        public void onError(Throwable throwable) {
            Single<T> fallback;
            this.upstream = SubscriptionHelper.CANCELED;
            try {
                fallback = Objects.requireNonNull(this.fallbackFunction.apply(throwable), "The fallback function returned a null Single");
            }
            catch (Throwable ex) {
                if (ex != throwable) {
                    ex.addSuppressed(throwable);
                }
                this.error(ex);
                return;
            }
            fallback.subscribe(this.fallbackSubscriber);
        }

        @Override
        public void onComplete() {
            if (this.upstream != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                this.complete();
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.upstream.cancel();
            SubscriptionHelper.cancel(this.fallbackSubscriber);
        }

        static final class FallbackSubscriber<T>
        extends AtomicReference<Flow.Subscription>
        implements Flow.Subscriber<T> {
            private final OnErrorResumeWithSubscriber<T> parent;

            FallbackSubscriber(OnErrorResumeWithSubscriber<T> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                SubscriptionHelper.setOnce(this, subscription);
                subscription.request(Long.MAX_VALUE);
            }

            @Override
            public void onNext(T item) {
                this.parent.complete(item);
            }

            @Override
            public void onError(Throwable throwable) {
                this.parent.error(throwable);
            }

            @Override
            public void onComplete() {
                this.parent.complete();
            }
        }
    }
}

