/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.StreamValidationUtils;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;

public class RequestedCounter {
    private final AtomicLong requested = new AtomicLong();
    private ReentrantLock counterLock = new ReentrantLock();
    private final boolean strictMode;

    public RequestedCounter() {
        this.strictMode = Boolean.FALSE;
    }

    public RequestedCounter(boolean strictMode) {
        this.strictMode = strictMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(long increment, Consumer<? super IllegalArgumentException> errorHandler) {
        if (!StreamValidationUtils.checkRequestParam(increment, errorHandler)) {
            return;
        }
        try {
            this.lock();
            this.requested.updateAndGet(original -> {
                if (original == Long.MAX_VALUE) {
                    return Long.MAX_VALUE;
                }
                if (Long.MAX_VALUE - original > increment) {
                    return original + increment;
                }
                return Long.MAX_VALUE;
            });
        }
        finally {
            this.unlock();
        }
    }

    public boolean tryDecrement() {
        try {
            this.lock();
            boolean bl = this.requested.getAndUpdate(val -> {
                if (val == Long.MAX_VALUE) {
                    return val;
                }
                if (val > 0L) {
                    return val - 1L;
                }
                return 0L;
            }) > 0L;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public void lock() {
        if (!this.strictMode) {
            return;
        }
        this.counterLock.lock();
    }

    public void unlock() {
        if (!this.strictMode) {
            return;
        }
        this.counterLock.unlock();
    }

    public long get() {
        return this.requested.get();
    }
}

