/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import io.helidon.common.reactive.TerminatedFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class MultiInterval
implements Multi<Long> {
    private final long initialDelay;
    private final long period;
    private final TimeUnit unit;
    private final ScheduledExecutorService executor;

    MultiInterval(long initialDelay, long period, TimeUnit unit, ScheduledExecutorService executor) {
        this.initialDelay = initialDelay;
        this.period = period;
        this.unit = unit;
        this.executor = executor;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super Long> subscriber) {
        IntervalSubscription subscription = new IntervalSubscription(subscriber);
        subscriber.onSubscribe(subscription);
        subscription.setFuture(this.executor.scheduleAtFixedRate(subscription, this.initialDelay, this.period, this.unit));
    }

    static final class IntervalSubscription
    extends AtomicInteger
    implements Flow.Subscription,
    Runnable {
        private final Flow.Subscriber<? super Long> downstream;
        private final AtomicLong requested;
        private final AtomicReference<Future<?>> future;
        private volatile long available;
        private volatile int canceled;
        private long emitted;
        private static final int NORMAL_CANCEL = 1;
        private static final int BAD_REQUEST = 2;

        IntervalSubscription(Flow.Subscriber<? super Long> downstream) {
            this.downstream = downstream;
            this.requested = new AtomicLong();
            this.future = new AtomicReference();
        }

        @Override
        public void run() {
            long next;
            this.available = next = this.available + 1L;
            this.drain();
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.canceled = 2;
                n = 1L;
            }
            SubscriptionHelper.addRequest(this.requested, n);
            this.drain();
        }

        @Override
        public void cancel() {
            this.canceled = 1;
            TerminatedFuture.cancel(this.future);
        }

        void setFuture(Future<?> f) {
            TerminatedFuture.setFuture(this.future, f);
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            do {
                int c;
                if ((c = this.canceled) != 0) {
                    if (c == 2) {
                        this.downstream.onError(new IllegalArgumentException("Rule \u00a73.9 violated: non-positive requests are forbidden"));
                    }
                    return;
                }
                long avail = this.available;
                long emit = this.emitted;
                long req = this.requested.get();
                if (emit == req || emit == avail) continue;
                this.downstream.onNext((Long)emit);
                this.emitted = emit + 1L;
            } while (this.decrementAndGet() != 0);
        }
    }
}

