/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;

final class MultiFromArrayPublisher<T>
implements Multi<T> {
    private final T[] items;

    MultiFromArrayPublisher(T[] items) {
        this.items = items;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        subscriber.onSubscribe(new ArraySubscription<T>(subscriber, this.items));
    }

    static final class ArraySubscription<T>
    extends AtomicLong
    implements Flow.Subscription {
        private final Flow.Subscriber<? super T> downstream;
        private final T[] array;
        private int index;
        private volatile int canceled;
        static final int CANCEL = 1;
        static final int BAD_REQUEST = 2;

        ArraySubscription(Flow.Subscriber<? super T> downstream, T[] array) {
            this.downstream = downstream;
            this.array = array;
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.canceled = 2;
                n = 1L;
            }
            if (SubscriptionHelper.addRequest(this, n) != 0L) {
                return;
            }
            long emitted = 0L;
            int i = this.index;
            T[] array = this.array;
            int length = array.length;
            block0: while (true) {
                int c;
                if ((c = this.canceled) != 0) {
                    if (c == 2) {
                        this.downstream.onError(new IllegalArgumentException("Rule \u00a73.9 violated: non-positive requests are forbidden"));
                    }
                    return;
                }
                while (i != length && emitted != n) {
                    T item = array[i];
                    if (item == null) {
                        c = 1;
                        this.downstream.onError(new NullPointerException("Array element at index " + i + " is null"));
                        return;
                    }
                    this.downstream.onNext(item);
                    if (this.canceled != 0) continue block0;
                    ++i;
                    ++emitted;
                }
                if (i == length) {
                    this.downstream.onComplete();
                    return;
                }
                n = this.get();
                if (n != emitted) continue;
                this.index = i;
                if ((n = SubscriptionHelper.produced(this, n)) == 0L) break;
                emitted = 0L;
            }
        }

        @Override
        public void cancel() {
            this.canceled = 1;
        }
    }
}

