/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

final class MultiFlatMapPublisher<T, R>
implements Multi<R> {
    private final Multi<T> source;
    private final Function<? super T, ? extends Flow.Publisher<? extends R>> mapper;
    private final long maxConcurrency;
    private final long prefetch;
    private final boolean delayErrors;

    MultiFlatMapPublisher(Multi<T> source, Function<? super T, ? extends Flow.Publisher<? extends R>> mapper, long maxConcurrency, long prefetch, boolean delayErrors) {
        this.source = source;
        this.mapper = mapper;
        this.maxConcurrency = maxConcurrency;
        this.prefetch = prefetch;
        this.delayErrors = delayErrors;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super R> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber is null");
        this.source.subscribe(new FlatMapSubscriber<T, R>(subscriber, this.mapper, this.maxConcurrency, this.prefetch, this.delayErrors));
    }

    static final class FlatMapAggregateException
    extends RuntimeException {
        FlatMapAggregateException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class FlatMapSubscriber<T, R>
    extends AtomicInteger
    implements Flow.Subscriber<T>,
    Flow.Subscription {
        private final Flow.Subscriber<? super R> downstream;
        private final Function<? super T, ? extends Flow.Publisher<? extends R>> mapper;
        private final long maxConcurrency;
        private final long prefetch;
        private final boolean delayErrors;
        private Flow.Subscription upstream;
        private volatile boolean upstreamDone;
        private final AtomicReference<Throwable> errors;
        private volatile boolean canceled;
        private final ConcurrentMap<InnerSubscriber<R>, Object> subscribers;
        private final AtomicReference<Queue<InnerSubscriber<R>>> queue;
        private final AtomicLong requested;
        private long emitted;

        FlatMapSubscriber(Flow.Subscriber<? super R> downstream, Function<? super T, ? extends Flow.Publisher<? extends R>> mapper, long maxConcurrency, long prefetch, boolean delayErrors) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.maxConcurrency = maxConcurrency;
            this.prefetch = prefetch;
            this.delayErrors = delayErrors;
            this.errors = new AtomicReference();
            this.subscribers = new ConcurrentHashMap<InnerSubscriber<R>, Object>();
            this.queue = new AtomicReference();
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            Objects.requireNonNull(subscription);
            if (this.upstream != null) {
                subscription.cancel();
                throw new IllegalStateException("Subscription already set");
            }
            this.upstream = subscription;
            this.downstream.onSubscribe(this);
            subscription.request(this.maxConcurrency);
        }

        @Override
        public void onNext(T item) {
            if (!this.upstreamDone) {
                Flow.Publisher<R> innerSource;
                try {
                    innerSource = Objects.requireNonNull(this.mapper.apply(item), "The mapper returned a null Publisher");
                }
                catch (Throwable ex) {
                    this.upstream.cancel();
                    this.onError(ex);
                    return;
                }
                InnerSubscriber innerSubscriber = new InnerSubscriber(this, this.prefetch);
                this.subscribers.put(innerSubscriber, innerSubscriber);
                if (this.canceled) {
                    this.subscribers.remove(innerSubscriber);
                    return;
                }
                innerSource.subscribe(innerSubscriber);
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (!this.upstreamDone) {
                this.doError(throwable);
            }
        }

        @Override
        public void onComplete() {
            if (!this.upstreamDone) {
                this.upstreamDone = true;
                this.drain();
            }
        }

        void doError(Throwable throwable) {
            if (this.delayErrors) {
                this.addError(throwable);
            } else {
                this.errors.compareAndSet(null, throwable);
                this.cancelInners();
            }
            this.upstreamDone = true;
            this.drain();
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.doError(new IllegalArgumentException("Rule \u00a73.9 violated: non-positive request amount is forbidden"));
            } else {
                SubscriptionHelper.addRequest(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.canceled = true;
            this.upstream.cancel();
            this.cancelInners();
        }

        void cancelInners() {
            for (InnerSubscriber inner : this.subscribers.keySet()) {
                inner.cancel();
            }
            this.subscribers.clear();
        }

        /*
         * Enabled aggressive block sorting
         */
        public void innerNext(R item, InnerSubscriber<R> sender) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                long e;
                long r = this.requested.get();
                if (r != (e = this.emitted)) {
                    Queue<InnerSubscriber<R>> q = this.queue.get();
                    if (q != null && !q.isEmpty()) {
                        sender.enqueue(item);
                        q.offer(sender);
                        this.drainLoop();
                        return;
                    }
                    this.emitted = e + 1L;
                    this.downstream.onNext(item);
                    sender.produced(1L);
                } else {
                    sender.enqueue(item);
                    this.getOrCreateQueue().offer(sender);
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                sender.enqueue(item);
                this.getOrCreateQueue().offer(sender);
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        public void innerError(Throwable ex, InnerSubscriber<R> sender) {
            if (this.delayErrors) {
                this.addError(ex);
                sender.setDone();
            } else {
                this.errors.compareAndSet(null, ex);
                this.upstream.cancel();
                this.cancelInners();
                sender.setDone();
                this.upstreamDone = true;
            }
            this.getOrCreateQueue().offer(sender);
            this.drain();
        }

        public void innerComplete(InnerSubscriber<R> sender) {
            sender.setDone();
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                Queue<R> innerQueue = sender.getQueue();
                if (innerQueue == null || innerQueue.isEmpty()) {
                    this.subscribers.remove(sender);
                    boolean done = this.upstreamDone;
                    Queue<InnerSubscriber<R>> mainQueue = this.queue.get();
                    boolean mainQueueEmpty = mainQueue == null || mainQueue.isEmpty();
                    boolean noMoreSubscribers = this.subscribers.isEmpty();
                    if (done && mainQueueEmpty && noMoreSubscribers) {
                        Throwable ex = this.errors.get();
                        if (ex == null) {
                            this.downstream.onComplete();
                        } else {
                            this.downstream.onError(ex);
                        }
                        this.canceled = true;
                    } else if (!done) {
                        this.upstream.request(1L);
                    }
                } else {
                    this.getOrCreateQueue().offer(sender);
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                this.getOrCreateQueue().offer(sender);
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        Queue<InnerSubscriber<R>> getOrCreateQueue() {
            Queue<InnerSubscriber<R>> q = this.queue.get();
            if (q == null && !this.queue.compareAndSet(null, q = new ConcurrentLinkedQueue<InnerSubscriber<R>>())) {
                q = this.queue.get();
            }
            return q;
        }

        void addError(Throwable throwable) {
            while (true) {
                Throwable ex;
                if ((ex = this.errors.get()) == null) {
                    if (!this.errors.compareAndSet(null, throwable)) continue;
                    return;
                }
                if (ex instanceof FlatMapAggregateException) {
                    ex.addSuppressed(throwable);
                    return;
                }
                FlatMapAggregateException newEx = new FlatMapAggregateException();
                newEx.addSuppressed(ex);
                newEx.addSuppressed(throwable);
                if (this.errors.compareAndSet(ex, newEx)) break;
            }
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            int missed = 1;
            long r = this.requested.get();
            long e = this.emitted;
            Flow.Subscriber<R> downstream = this.downstream;
            AtomicReference<Queue<InnerSubscriber<R>>> queue = this.queue;
            ConcurrentMap<InnerSubscriber<R>, Object> subscribers = this.subscribers;
            while (true) {
                if (this.canceled) {
                    queue.lazySet(null);
                    subscribers.clear();
                } else {
                    boolean noQueuedItems;
                    Throwable ex;
                    if (!this.delayErrors && (ex = this.errors.get()) != null) {
                        this.canceled = true;
                        downstream.onError(ex);
                        continue;
                    }
                    boolean done = this.upstreamDone;
                    boolean noActiveInnerSubscribers = subscribers.isEmpty();
                    Queue<InnerSubscriber<R>> q = queue.get();
                    boolean bl = noQueuedItems = q == null || q.isEmpty();
                    if (done && noActiveInnerSubscribers && noQueuedItems) {
                        this.canceled = true;
                        Throwable ex2 = this.errors.get();
                        if (ex2 != null) {
                            downstream.onError(ex2);
                            continue;
                        }
                        downstream.onComplete();
                        continue;
                    }
                    if (!noQueuedItems) {
                        boolean innerEmpty;
                        InnerSubscriber<R> inner = q.peek();
                        boolean innerDone = inner.isDone();
                        Queue<R> innerQueue = inner.getQueue();
                        boolean bl2 = innerEmpty = innerQueue == null || innerQueue.isEmpty();
                        if (innerDone && innerEmpty) {
                            subscribers.remove(inner);
                            q.poll();
                            this.upstream.request(1L);
                            continue;
                        }
                        if (!innerEmpty && r != e) {
                            q.poll();
                            R v = innerQueue.poll();
                            ++e;
                            downstream.onNext(v);
                            inner.produced(1L);
                            continue;
                        }
                    }
                }
                this.emitted = e;
                missed = this.addAndGet(-missed);
                if (missed == 0) break;
                r = this.requested.get();
            }
        }

        static final class InnerSubscriber<R>
        extends AtomicReference<Flow.Subscription>
        implements Flow.Subscriber<R>,
        Flow.Subscription {
            private final FlatMapSubscriber<?, R> parent;
            private final long prefetch;
            private final long limit;
            private long produced;
            private volatile boolean done;
            private volatile Queue<R> queue;

            InnerSubscriber(FlatMapSubscriber<?, R> parent, long prefetch) {
                this.parent = parent;
                this.prefetch = prefetch;
                this.limit = prefetch - (prefetch >> 2);
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                if (SubscriptionHelper.setOnce(this, subscription)) {
                    subscription.request(this.prefetch);
                }
            }

            @Override
            public void onNext(R item) {
                this.parent.innerNext(item, this);
            }

            @Override
            public void onError(Throwable throwable) {
                this.lazySet(this);
                this.parent.innerError(throwable, this);
            }

            @Override
            public void onComplete() {
                this.lazySet(this);
                this.parent.innerComplete(this);
            }

            @Override
            public void request(long n) {
            }

            public void produced(long n) {
                long p = this.produced + n;
                if (p >= this.limit) {
                    this.produced = 0L;
                    ((Flow.Subscription)this.get()).request(p);
                } else {
                    this.produced = p;
                }
            }

            @Override
            public void cancel() {
                Flow.Subscription s = this.getAndSet(this);
                if (s != null && s != this) {
                    s.cancel();
                }
            }

            public Queue<R> getQueue() {
                return this.queue;
            }

            public void enqueue(R item) {
                Queue<R> q = this.queue;
                if (q == null) {
                    q = new ConcurrentLinkedQueue<R>();
                    this.queue = q;
                }
                q.offer(item);
            }

            public void setDone() {
                this.done = true;
            }

            public boolean isDone() {
                return this.done;
            }

            @Override
            public String toString() {
                boolean d = this.done;
                Queue<R> q = this.queue;
                return "InnerSubscriber{done=" + d + ", queue=" + String.valueOf(q != null ? Integer.valueOf(q.size()) : "null") + "}";
            }
        }
    }
}

