/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Predicate;

final class MultiFilterPublisher<T>
implements Multi<T> {
    private final Multi<T> source;
    private final Predicate<? super T> predicate;

    MultiFilterPublisher(Multi<T> source, Predicate<? super T> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        this.source.subscribe(new FilterSubscriber<T>(subscriber, this.predicate));
    }

    static final class FilterSubscriber<T>
    implements Flow.Subscriber<T>,
    Flow.Subscription {
        private final Flow.Subscriber<? super T> downstream;
        private final Predicate<? super T> predicate;
        private Flow.Subscription upstream;

        FilterSubscriber(Flow.Subscriber<? super T> downstream, Predicate<? super T> predicate) {
            this.downstream = downstream;
            this.predicate = predicate;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            if (this.upstream != null) {
                subscription.cancel();
                throw new IllegalStateException("Subscription already set!");
            }
            this.upstream = Objects.requireNonNull(subscription, "subscription is null");
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onNext(T item) {
            Flow.Subscription s = this.upstream;
            if (s != null) {
                boolean pass;
                try {
                    pass = this.predicate.test(item);
                }
                catch (Throwable ex) {
                    s.cancel();
                    this.onError(ex);
                    return;
                }
                if (pass) {
                    this.downstream.onNext(item);
                } else {
                    s.request(1L);
                }
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.upstream != null) {
                this.upstream = null;
                this.downstream.onError(throwable);
            }
        }

        @Override
        public void onComplete() {
            if (this.upstream != null) {
                this.upstream = null;
                this.downstream.onComplete();
            }
        }

        @Override
        public void request(long n) {
            Flow.Subscription s = this.upstream;
            if (s != null) {
                s.request(n);
            }
        }

        @Override
        public void cancel() {
            Flow.Subscription s = this.upstream;
            this.upstream = null;
            if (s != null) {
                s.cancel();
            }
        }
    }
}

