/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SingleDeferredSubscription;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

final class MultiDeferredDefaultIfEmpty<T>
implements Multi<T> {
    private final Multi<T> source;
    private final Supplier<? extends T> defaultItemSupplier;

    MultiDeferredDefaultIfEmpty(Multi<T> source, Supplier<? extends T> defaultItem) {
        this.source = source;
        this.defaultItemSupplier = defaultItem;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        this.source.subscribe(new DefaultIfEmptySubscriber<T>(subscriber, this.defaultItemSupplier));
    }

    static final class DefaultIfEmptySubscriber<T>
    implements Flow.Subscriber<T>,
    Flow.Subscription {
        private final Flow.Subscriber<? super T> downstream;
        private final Supplier<? extends T> defaultItemSupplier;
        private final AtomicLong requested;
        private final AtomicReference<Flow.Subscription> fallback;
        private Flow.Subscription upstream;
        private boolean nonEmpty;

        DefaultIfEmptySubscriber(Flow.Subscriber<? super T> downstream, Supplier<? extends T> defaultItem) {
            this.downstream = downstream;
            this.defaultItemSupplier = defaultItem;
            this.requested = new AtomicLong();
            this.fallback = new AtomicReference();
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onNext(T item) {
            this.nonEmpty = true;
            this.downstream.onNext(item);
        }

        @Override
        public void onError(Throwable throwable) {
            this.downstream.onError(throwable);
        }

        @Override
        public void onComplete() {
            if (this.nonEmpty) {
                this.downstream.onComplete();
            } else {
                SubscriptionHelper.deferredSetOnce(this.fallback, this.requested, new SingleDeferredSubscription<T>(this.defaultItemSupplier, this.downstream));
            }
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
            SubscriptionHelper.deferredRequest(this.fallback, this.requested, n);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            SubscriptionHelper.cancel(this.fallback);
        }
    }
}

