/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.MultiTappedPublisher;
import io.helidon.common.reactive.NamedOperator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

class LoggingPublisher<T>
implements Flow.Publisher<T> {
    private static final Logger LOGGER = Logger.getLogger(LoggingPublisher.class.getName());
    private static final AtomicLong LOG_ID = new AtomicLong();
    private final String caller;
    private final String loggerName;
    private final String methodName;
    private final Flow.Publisher<T> source;
    private final Level level;

    LoggingPublisher(Flow.Publisher<T> source, Level level, String loggerName) {
        Objects.requireNonNull(loggerName);
        this.source = source;
        this.level = level;
        this.loggerName = loggerName;
        this.caller = this.resolveCaller(source);
        this.methodName = "log()";
    }

    LoggingPublisher(Flow.Publisher<T> source, Level level, boolean trace) {
        Optional<StackWalker.StackFrame> frm;
        this.source = source;
        this.level = level;
        if (trace && (frm = this.findCaller()).isPresent()) {
            this.caller = frm.map(StackWalker.StackFrame::getClassName).orElse(Multi.class.getName());
            String fileName = frm.map(f -> f.getFileName() + ":" + f.getLineNumber()).orElse("");
            this.methodName = frm.map(StackWalker.StackFrame::getMethodName).orElse("log") + "(" + fileName + ")";
            this.loggerName = this.caller + "." + this.methodName;
            return;
        }
        this.caller = this.resolveCaller(source);
        this.methodName = "log()";
        this.loggerName = Multi.class.getSimpleName() + ".log(" + LOG_ID.incrementAndGet() + ")";
    }

    private String resolveCaller(Flow.Publisher<T> source) {
        if (source instanceof NamedOperator) {
            return ((NamedOperator)((Object)source)).operatorName();
        }
        return source.getClass().getSimpleName();
    }

    private Optional<StackWalker.StackFrame> findCaller() {
        return StackWalker.getInstance().walk(frmStream -> frmStream.limit(4L).skip(3L).findFirst());
    }

    void log(Supplier<String> msgSupplier) {
        if (!LOGGER.isLoggable(this.level)) {
            return;
        }
        LogRecord record = new LogRecord(this.level, msgSupplier.get());
        record.setSourceClassName(this.caller);
        record.setSourceMethodName(this.methodName);
        record.setLoggerName(this.loggerName);
        LOGGER.log(record);
    }

    void logCancel() {
        this.log(() -> " \u21d7 cancel()");
    }

    void logOnComplete() {
        this.log(() -> " \u21d8 onComplete()");
    }

    void logRequest(long n) {
        this.log(() -> " \u21d7 request(" + String.valueOf(n == Long.MAX_VALUE ? "Long.MAX_VALUE" : Long.valueOf(n)) + ")");
    }

    void logOnError(Throwable throwable) {
        this.log(() -> " \u21d8 onError(" + String.valueOf(throwable) + ")");
    }

    void logOnSubscribe(Flow.Subscription subscription) {
        this.log(() -> " \u21d8 onSubscribe(...)");
    }

    void logOnNext(T item) {
        this.log(() -> " \u21d8 onNext(" + String.valueOf(item) + ")");
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber is null");
        this.source.subscribe(new MultiTappedPublisher.MultiTappedSubscriber<Object>(subscriber, this::logOnSubscribe, this::logOnNext, this::logOnError, this::logOnComplete, this::logRequest, this::logCancel));
    }
}

