/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.LazyValue;
import io.helidon.common.reactive.BiConsumerChain;
import io.helidon.common.reactive.RunnableChain;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;

public class EmittingPublisher<T>
implements Flow.Publisher<T> {
    private volatile Flow.Subscriber<? super T> subscriber;
    private volatile Throwable error = null;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
    private final AtomicLong requested = new AtomicLong();
    private final AtomicBoolean subscribed = new AtomicBoolean(false);
    private final LazyValue<Boolean> unbounded = LazyValue.create(() -> this.requested.get() == Long.MAX_VALUE);
    private final CompletableFuture<Void> deferredComplete = new CompletableFuture();
    private BiConsumer<Long, Long> requestCallback = null;
    private Runnable onSubscribeCallback = () -> {};
    private Runnable cancelCallback = () -> {};

    EmittingPublisher() {
    }

    public static <T> EmittingPublisher<T> create() {
        return new EmittingPublisher<T>();
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber is null");
        if (!this.subscribed.compareAndSet(false, true)) {
            subscriber.onSubscribe(SubscriptionHelper.CANCELED);
            subscriber.onError(new IllegalStateException("Only single subscriber is allowed!"));
            return;
        }
        this.unsafeSubscribe(subscriber);
    }

    void unsafeSubscribe(Flow.Subscriber<? super T> subscriber) {
        this.subscriber = subscriber;
        subscriber.onSubscribe(new Flow.Subscription(){

            @Override
            public void request(long n) {
                if (EmittingPublisher.this.state.get().isTerminated()) {
                    return;
                }
                if (n < 1L) {
                    EmittingPublisher.this.fail(new IllegalArgumentException("Rule \u00a73.9 violated: non-positive request amount is forbidden"));
                    return;
                }
                EmittingPublisher.this.requested.updateAndGet(r -> Long.MAX_VALUE - r > n ? n + r : Long.MAX_VALUE);
                EmittingPublisher.this.state.compareAndSet(State.INIT, State.REQUESTED);
                if (EmittingPublisher.this.state.updateAndGet(s -> s == State.SUBSCRIBED ? State.READY_TO_EMIT : s) == State.READY_TO_EMIT && EmittingPublisher.this.requestCallback != null) {
                    EmittingPublisher.this.requestCallback.accept(n, EmittingPublisher.this.requested.get());
                }
            }

            @Override
            public void cancel() {
                if (EmittingPublisher.this.state.getAndUpdate(s -> s != State.COMPLETED && s != State.FAILED ? State.CANCELLED : s) != State.CANCELLED) {
                    EmittingPublisher.this.cancelCallback.run();
                    EmittingPublisher.this.subscriber = null;
                }
            }
        });
        this.state.compareAndSet(State.INIT, State.SUBSCRIBED);
        if (this.state.compareAndSet(State.REQUESTED, State.READY_TO_EMIT) && this.requestCallback != null) {
            this.requestCallback.accept(this.requested.get(), this.requested.get());
        }
        this.deferredComplete.complete(null);
        this.onSubscribeCallback.run();
    }

    public void fail(Throwable throwable) {
        if (this.deferredComplete.isDone()) {
            this.signalOnError(throwable);
        } else {
            this.deferredComplete.thenRun(() -> this.signalOnError(throwable));
        }
    }

    public void complete() {
        this.deferredComplete.thenRun(this::signalOnComplete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalOnError(Throwable throwable) {
        EmittingPublisher emittingPublisher = this;
        synchronized (emittingPublisher) {
            try {
                Flow.Subscriber<T> subscriber = this.subscriber;
                if (subscriber == null) {
                    return;
                }
                if (this.state.compareAndSet(State.INIT, State.FAILED) || this.state.compareAndSet(State.SUBSCRIBED, State.FAILED) || this.state.compareAndSet(State.REQUESTED, State.FAILED) || this.state.compareAndSet(State.READY_TO_EMIT, State.FAILED)) {
                    this.error = throwable;
                    this.subscriber = null;
                    subscriber.onError(throwable);
                }
            }
            catch (Throwable t) {
                throw new IllegalStateException("On error threw an exception!", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalOnComplete() {
        EmittingPublisher emittingPublisher = this;
        synchronized (emittingPublisher) {
            Flow.Subscriber<T> subscriber = this.subscriber;
            if (subscriber == null) {
                return;
            }
            if (this.state.compareAndSet(State.INIT, State.COMPLETED) || this.state.compareAndSet(State.SUBSCRIBED, State.COMPLETED) || this.state.compareAndSet(State.REQUESTED, State.COMPLETED) || this.state.compareAndSet(State.READY_TO_EMIT, State.COMPLETED)) {
                this.subscriber = null;
                subscriber.onComplete();
            }
        }
    }

    public boolean emit(T item) {
        return this.state.get().emit(this, item);
    }

    public boolean isCompleted() {
        return this.state.get() == State.COMPLETED;
    }

    public boolean isCancelled() {
        return this.state.get() == State.CANCELLED;
    }

    public boolean isFailed() {
        return this.state.get() == State.FAILED;
    }

    public boolean hasRequests() {
        return this.requested.get() > 0L;
    }

    public boolean isUnbounded() {
        return this.state.get() == State.READY_TO_EMIT && (Boolean)this.unbounded.get() != false;
    }

    public Optional<Throwable> failCause() {
        return Optional.ofNullable(this.error);
    }

    void onSubscribe(Runnable onSubscribeCallback) {
        this.onSubscribeCallback = RunnableChain.combine(this.onSubscribeCallback, onSubscribeCallback);
    }

    public void onCancel(Runnable cancelCallback) {
        this.cancelCallback = RunnableChain.combine(this.cancelCallback, cancelCallback);
    }

    public void onRequest(BiConsumer<Long, Long> requestCallback) {
        this.requestCallback = this.requestCallback == null ? requestCallback : BiConsumerChain.combine(this.requestCallback, requestCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalEmit(T item) {
        Throwable error;
        EmittingPublisher emittingPublisher = this;
        synchronized (emittingPublisher) {
            try {
                if (State.READY_TO_EMIT != this.state.get()) {
                    return false;
                }
                Flow.Subscriber<T> subscriber = this.subscriber;
                if (subscriber == null) {
                    return false;
                }
                if (this.requested.getAndUpdate(r -> r > 0L ? (r != Long.MAX_VALUE ? r - 1L : Long.MAX_VALUE) : 0L) < 1L) {
                    return false;
                }
                subscriber.onNext(item);
                return true;
            }
            catch (NullPointerException npe) {
                throw npe;
            }
            catch (Throwable t) {
                error = t;
            }
        }
        this.fail(new IllegalStateException(error));
        return false;
    }

    private static enum State {
        INIT{

            @Override
            <T> boolean emit(EmittingPublisher<T> publisher, T item) {
                return false;
            }

            @Override
            boolean isTerminated() {
                return false;
            }
        }
        ,
        REQUESTED{

            @Override
            <T> boolean emit(EmittingPublisher<T> publisher, T item) {
                return false;
            }

            @Override
            boolean isTerminated() {
                return false;
            }
        }
        ,
        SUBSCRIBED{

            @Override
            <T> boolean emit(EmittingPublisher<T> publisher, T item) {
                return false;
            }

            @Override
            boolean isTerminated() {
                return false;
            }
        }
        ,
        READY_TO_EMIT{

            @Override
            <T> boolean emit(EmittingPublisher<T> publisher, T item) {
                return publisher.internalEmit(item);
            }

            @Override
            boolean isTerminated() {
                return false;
            }
        }
        ,
        CANCELLED{

            @Override
            <T> boolean emit(EmittingPublisher<T> publisher, T item) {
                return false;
            }

            @Override
            boolean isTerminated() {
                return true;
            }
        }
        ,
        FAILED{

            @Override
            <T> boolean emit(EmittingPublisher<T> publisher, T item) {
                return false;
            }

            @Override
            boolean isTerminated() {
                return true;
            }
        }
        ,
        COMPLETED{

            @Override
            <T> boolean emit(EmittingPublisher<T> publisher, T item) {
                throw new IllegalStateException("Emitter is completed!");
            }

            @Override
            boolean isTerminated() {
                return true;
            }
        };


        abstract <T> boolean emit(EmittingPublisher<T> var1, T var2);

        abstract boolean isTerminated();
    }
}

