/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import java.util.ArrayList;
import java.util.function.Consumer;

class ConsumerChain<T>
extends ArrayList<Consumer<? super T>>
implements Consumer<T> {
    ConsumerChain() {
    }

    @Override
    public void accept(T t) {
        for (Consumer inner : this) {
            inner.accept(t);
        }
    }

    ConsumerChain<T> combineWith(Consumer<? super T> another) {
        ConsumerChain<T> newChain = new ConsumerChain<T>();
        newChain.addAll(this);
        newChain.add(another);
        return newChain;
    }

    static <T> Consumer<? super T> combine(Consumer<? super T> current, Consumer<? super T> another) {
        if (current == null) {
            return another;
        }
        if (another == null) {
            return current;
        }
        if (current instanceof ConsumerChain) {
            return ((ConsumerChain)current).combineWith(another);
        }
        ConsumerChain<T> newChain = new ConsumerChain<T>();
        newChain.add(current);
        newChain.add(another);
        return newChain;
    }
}

