/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.CompletionSingle;
import io.helidon.common.reactive.Single;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Flow;

class ByteChannelSubscriber
extends CompletionSingle<Void>
implements Flow.Subscriber<ByteBuffer> {
    private final ExecutorService executorService;
    private Flow.Subscription subscription;
    private final WritableByteChannel byteChannel;
    private final Executor executor;
    private final CompletableFuture<Void> completed = new CompletableFuture();
    private volatile CompletableFuture<Void> lastWriteFinished = CompletableFuture.completedFuture(null);

    ByteChannelSubscriber(WritableByteChannel byteChannel, ExecutorService executor) {
        this.byteChannel = byteChannel;
        this.executor = executor;
        this.executorService = executor;
    }

    ByteChannelSubscriber(WritableByteChannel byteChannel, Executor executor) {
        this.byteChannel = byteChannel;
        this.executor = executor;
        this.executorService = null;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        this.subscription.request(1L);
    }

    @Override
    public void onNext(ByteBuffer nextByteBuffer) {
        this.lastWriteFinished = ((CompletableFuture)CompletableFuture.runAsync(() -> {
            try {
                while (true) {
                    this.byteChannel.write(nextByteBuffer);
                    if (nextByteBuffer.remaining() != 0) {
                        Thread.onSpinWait();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, this.executor).exceptionally(throwable -> {
            this.subscription.cancel();
            this.completed.completeExceptionally((Throwable)throwable);
            return null;
        })).thenRun(() -> this.subscription.request(1L));
    }

    @Override
    public void onError(Throwable throwable) {
        try {
            this.byteChannel.close();
        }
        catch (IOException e) {
            throwable.addSuppressed(e);
        }
        this.completed.completeExceptionally(throwable);
    }

    @Override
    public void onComplete() {
        this.lastWriteFinished.thenRun(() -> {
            try {
                this.byteChannel.close();
                this.completed.complete(null);
            }
            catch (IOException e) {
                this.completed.completeExceptionally(e);
            }
            finally {
                if (this.executorService != null) {
                    this.executorService.shutdown();
                }
            }
        });
    }

    @Override
    public void subscribe(Flow.Subscriber<? super Void> subscriber) {
        Single.create(this.completed, true).subscribe(subscriber);
    }
}

