/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import java.util.ArrayList;
import java.util.function.BiConsumer;

class BiConsumerChain<T, S>
extends ArrayList<BiConsumer<? super T, ? super S>>
implements BiConsumer<T, S> {
    BiConsumerChain() {
    }

    @Override
    public void accept(T t, S s) {
        for (BiConsumer inner : this) {
            inner.accept(t, s);
        }
    }

    BiConsumerChain<T, S> combineWith(BiConsumer<? super T, ? super S> another) {
        BiConsumerChain<T, S> newChain = new BiConsumerChain<T, S>();
        newChain.addAll(this);
        newChain.add(another);
        return newChain;
    }

    static <T, S> BiConsumer<T, S> combine(BiConsumer<T, S> current, BiConsumer<T, S> another) {
        if (current == null) {
            return another;
        }
        if (another == null) {
            return current;
        }
        if (current instanceof BiConsumerChain) {
            return ((BiConsumerChain)current).combineWith(another);
        }
        BiConsumerChain<T, S> newChain = new BiConsumerChain<T, S>();
        if (current instanceof BiConsumerChain) {
            newChain.addAll((BiConsumerChain)current);
        } else {
            newChain.add(current);
        }
        if (another instanceof BiConsumerChain) {
            newChain.addAll((BiConsumerChain)another);
        } else {
            newChain.add(another);
        }
        return newChain;
    }
}

