/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.common.LazyValue;
import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.faulttolerance.FaultTolerance;
import io.helidon.faulttolerance.FtHandler;
import io.helidon.faulttolerance.RetryImpl;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;

public interface Retry
extends FtHandler {
    public static Builder builder() {
        return new Builder();
    }

    public long retryCounter();

    public static class ExponentialRetryPolicy
    implements RetryPolicy {
        private final int calls;
        private final Duration initialDelay;
        private final Duration maxDelay;
        private final int factor;
        private final Supplier<Long> jitter;
        private long accumulateDelay;

        private ExponentialRetryPolicy(Builder builder) {
            int jitterMillis;
            this.calls = builder.calls;
            this.initialDelay = builder.initialDelay;
            this.maxDelay = builder.maxDelay;
            this.factor = builder.factor;
            long jitter = builder.jitter;
            int n = jitterMillis = jitter > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)jitter;
            if ((long)jitterMillis == 0L) {
                this.jitter = () -> 0L;
            } else {
                Random random = new Random();
                this.jitter = () -> random.nextInt(jitterMillis * 2 - jitterMillis);
            }
        }

        public static Builder builder() {
            return new Builder();
        }

        @Override
        public Optional<Long> nextDelayMillis(long firstCallMillis, long lastDelay, int call) {
            if (call >= this.calls) {
                return Optional.empty();
            }
            if (this.accumulateDelay == 0L) {
                this.accumulateDelay = this.initialDelay.toMillis();
                return Optional.of(this.accumulateDelay + this.jitter.get());
            }
            this.accumulateDelay *= (long)this.factor;
            if (this.accumulateDelay >= this.maxDelay.toMillis()) {
                return Optional.empty();
            }
            return Optional.of(this.accumulateDelay + this.jitter.get());
        }

        @Configured(provides={RetryPolicy.class})
        public static class Builder
        implements io.helidon.common.Builder<ExponentialRetryPolicy> {
            private int calls = 10;
            private Duration initialDelay = Duration.ofMillis(2L);
            private Duration maxDelay = Duration.ofMillis(180000L);
            private int factor = 2;
            private long jitter = 50L;

            public ExponentialRetryPolicy build() {
                return new ExponentialRetryPolicy(this);
            }

            public Builder calls(int calls) {
                this.calls = calls;
                return this;
            }

            public Builder initialDelay(Duration initialDelay) {
                this.initialDelay = initialDelay;
                return this;
            }

            public Builder maxDelay(Duration maxDelay) {
                this.maxDelay = maxDelay;
                return this;
            }

            public Builder factor(int factor) {
                this.factor = factor;
                return this;
            }

            public Builder jitter(long jitter) {
                this.jitter = jitter;
                return this;
            }

            public Builder config(Config config) {
                config.get("calls").asInt().ifPresent(this::calls);
                config.get("initial-delay").as(Duration.class).ifPresent(this::initialDelay);
                config.get("max-delay").as(Duration.class).ifPresent(this::maxDelay);
                config.get("factor").asInt().ifPresent(this::factor);
                config.get("jitter").asLong().ifPresent(this::jitter);
                return this;
            }
        }
    }

    public static class FibonacciRetryPolicy
    implements RetryPolicy {
        private final int calls;
        private final Duration initialDelay;
        private final Duration maxDelay;
        private final Supplier<Long> randomJitter;
        private long delayA;
        private long delayB;

        private FibonacciRetryPolicy(Builder builder) {
            this.calls = builder.calls;
            this.initialDelay = builder.initialDelay;
            this.maxDelay = builder.maxDelay;
            long jitter = builder.randomJitter;
            int jitterMillis = (int)Math.min(jitter, Integer.MAX_VALUE);
            if ((long)jitterMillis == 0L) {
                this.randomJitter = () -> 0L;
            } else {
                Random random = new Random();
                this.randomJitter = () -> random.nextInt(jitterMillis * 2) - jitterMillis;
            }
        }

        public static Builder builder() {
            return new Builder();
        }

        @Override
        public Optional<Long> nextDelayMillis(long firstCallMillis, long lastDelay, int call) {
            if (call >= this.calls) {
                return Optional.empty();
            }
            if (this.delayA == 0L) {
                this.delayA = this.initialDelay.toMillis();
                return Optional.of(this.delayA + this.randomJitter.get());
            }
            if (this.delayB == 0L) {
                this.delayB = this.initialDelay.toMillis() << 1;
                return Optional.of(this.delayB + this.randomJitter.get());
            }
            long delay = this.delayA + this.delayB;
            this.delayA = this.delayB;
            this.delayB = delay;
            if (delay >= this.maxDelay.toMillis()) {
                return Optional.empty();
            }
            return Optional.of(delay + this.randomJitter.get());
        }

        @Configured(provides={RetryPolicy.class})
        public static class Builder
        implements io.helidon.common.Builder<FibonacciRetryPolicy> {
            private int calls = 10;
            private Duration initialDelay = Duration.ofMillis(2L);
            private Duration maxDelay = Duration.ofMillis(180000L);
            private long randomJitter = 50L;

            public FibonacciRetryPolicy build() {
                return new FibonacciRetryPolicy(this);
            }

            public Builder calls(int calls) {
                this.calls = calls;
                return this;
            }

            public Builder initialDelay(Duration initialDelay) {
                this.initialDelay = initialDelay;
                return this;
            }

            public Builder maxDelay(Duration maxDelay) {
                this.maxDelay = maxDelay;
                return this;
            }

            public Builder jitter(long jitter) {
                this.randomJitter = jitter;
                return this;
            }

            public Builder config(Config config) {
                config.get("calls").asInt().ifPresent(this::calls);
                config.get("initial-delay").as(Duration.class).ifPresent(this::initialDelay);
                config.get("max-delay").as(Duration.class).ifPresent(this::maxDelay);
                config.get("jitter").asLong().ifPresent(this::jitter);
                return this;
            }
        }
    }

    public static class JitterRetryPolicy
    implements RetryPolicy {
        private final int calls;
        private final long delayMillis;
        private final Supplier<Integer> randomJitter;

        private JitterRetryPolicy(Builder builder) {
            int jitterMillis;
            this.calls = builder.calls;
            this.delayMillis = builder.delay.toMillis();
            long jitter = builder.jitter.toMillis();
            int n = jitterMillis = jitter > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)jitter;
            if (jitterMillis == 0) {
                this.randomJitter = () -> 0;
            } else {
                Random random = new Random();
                this.randomJitter = () -> random.nextInt(jitterMillis * 2) - jitterMillis;
            }
        }

        public static Builder builder() {
            return new Builder();
        }

        int calls() {
            return this.calls;
        }

        Duration delay() {
            return Duration.ofMillis(this.delayMillis);
        }

        @Override
        public Optional<Long> nextDelayMillis(long firstCallNanos, long lastDelay, int call) {
            if (call >= this.calls) {
                return Optional.empty();
            }
            long delay = this.delayMillis;
            int jitterRandom = this.randomJitter.get();
            delay += (long)jitterRandom;
            delay = Math.max(0L, delay);
            return Optional.of(delay);
        }

        @Configured
        public static class Builder
        implements io.helidon.common.Builder<JitterRetryPolicy> {
            private int calls = 3;
            private Duration delay = Duration.ofMillis(200L);
            private Duration jitter = Duration.ofMillis(50L);

            private Builder() {
            }

            public JitterRetryPolicy build() {
                return new JitterRetryPolicy(this);
            }

            public Builder calls(int calls) {
                this.calls = calls;
                return this;
            }

            public Builder delay(Duration delay) {
                this.delay = delay;
                return this;
            }

            public Builder jitter(Duration jitter) {
                this.jitter = jitter;
                return this;
            }

            public Builder config(Config config) {
                config.get("calls").asInt().ifPresent(this::calls);
                config.get("delay").as(Duration.class).ifPresent(this::delay);
                config.get("delay-factor").as(Duration.class).ifPresent(this::jitter);
                return this;
            }
        }
    }

    public static class DelayingRetryPolicy
    implements RetryPolicy {
        private final int calls;
        private final long delayMillis;
        private final double delayFactor;

        private DelayingRetryPolicy(Builder builder) {
            this.calls = builder.calls;
            this.delayMillis = builder.delay.toMillis();
            this.delayFactor = builder.delayFactor;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static DelayingRetryPolicy noDelay(int calls) {
            return DelayingRetryPolicy.builder().delay(Duration.ZERO).delayFactor(0.0).calls(calls).build();
        }

        int calls() {
            return this.calls;
        }

        Duration delay() {
            return Duration.ofMillis(this.delayMillis);
        }

        double delayFactor() {
            return this.delayFactor;
        }

        @Override
        public Optional<Long> nextDelayMillis(long firstCallMillis, long lastDelay, int call) {
            if (call >= this.calls) {
                return Optional.empty();
            }
            if (call == 0) {
                return Optional.of(0L);
            }
            if (call == 1) {
                return Optional.of(this.delayMillis);
            }
            return Optional.of((long)((double)lastDelay * this.delayFactor));
        }

        @Configured
        public static class Builder
        implements io.helidon.common.Builder<DelayingRetryPolicy> {
            private int calls = 3;
            private double delayFactor = 2.0;
            private Duration delay = Duration.ofMillis(200L);

            public DelayingRetryPolicy build() {
                return new DelayingRetryPolicy(this);
            }

            public Builder calls(int calls) {
                this.calls = calls;
                return this;
            }

            public Builder delay(Duration delay) {
                this.delay = delay;
                return this;
            }

            public Builder delayFactor(double delayFactor) {
                this.delayFactor = delayFactor;
                return this;
            }

            public Builder config(Config config) {
                config.get("calls").asInt().ifPresent(this::calls);
                config.get("delay").as(Duration.class).ifPresent(this::delay);
                config.get("delay-factor").asDouble().ifPresent(this::delayFactor);
                return this;
            }
        }
    }

    public static interface RetryPolicy {
        public Optional<Long> nextDelayMillis(long var1, long var3, int var5);
    }

    @Configured
    public static class Builder
    implements io.helidon.common.Builder<Retry> {
        private final Set<Class<? extends Throwable>> applyOn = new HashSet<Class<? extends Throwable>>();
        private final Set<Class<? extends Throwable>> skipOn = new HashSet<Class<? extends Throwable>>();
        private RetryPolicy retryPolicy = JitterRetryPolicy.builder().calls(4).delay(Duration.ofMillis(200L)).jitter(Duration.ofMillis(50L)).build();
        private Duration overallTimeout = Duration.ofSeconds(1L);
        private LazyValue<? extends ScheduledExecutorService> scheduledExecutor = FaultTolerance.scheduledExecutor();
        private String name = "Retry-" + System.identityHashCode(this);
        private boolean cancelSource = true;

        private Builder() {
        }

        public Retry build() {
            return new RetryImpl(this);
        }

        public Builder retryPolicy(RetryPolicy policy) {
            this.retryPolicy = policy;
            return this;
        }

        @SafeVarargs
        public final Builder applyOn(Class<? extends Throwable> ... classes) {
            this.applyOn.clear();
            Arrays.stream(classes).forEach(this::addApplyOn);
            return this;
        }

        public Builder addApplyOn(Class<? extends Throwable> clazz) {
            this.applyOn.add(clazz);
            return this;
        }

        @SafeVarargs
        public final Builder skipOn(Class<? extends Throwable> ... classes) {
            this.skipOn.clear();
            Arrays.stream(classes).forEach(this::addSkipOn);
            return this;
        }

        public Builder addSkipOn(Class<? extends Throwable> clazz) {
            this.skipOn.add(clazz);
            return this;
        }

        public Builder scheduledExecutor(ScheduledExecutorService scheduledExecutor) {
            this.scheduledExecutor = LazyValue.create((Object)scheduledExecutor);
            return this;
        }

        public Builder overallTimeout(Duration overallTimeout) {
            this.overallTimeout = overallTimeout;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder cancelSource(boolean cancelSource) {
            this.cancelSource = cancelSource;
            return this;
        }

        public Builder config(Config config) {
            config.get("overall-timeout").as(Duration.class).ifPresent(this::overallTimeout);
            config.get("name").asString().ifPresent(this::name);
            config.get("cancel-source").asBoolean().ifPresent(this::cancelSource);
            boolean hasRetryPolicy = false;
            if (config.get("delaying-retry-policy").exists()) {
                hasRetryPolicy = true;
                this.retryPolicy(DelayingRetryPolicy.builder().config(config.get("delaying-retry-policy")).build());
            }
            if (config.get("jitter-retry-policy").exists()) {
                if (hasRetryPolicy) {
                    throw new IllegalArgumentException("Retry must not define multiple retry policies");
                }
                this.retryPolicy(JitterRetryPolicy.builder().config(config.get("jitter-retry-policy")).build());
            }
            return this;
        }

        Set<Class<? extends Throwable>> applyOn() {
            return this.applyOn;
        }

        Set<Class<? extends Throwable>> skipOn() {
            return this.skipOn;
        }

        RetryPolicy retryPolicy() {
            return this.retryPolicy;
        }

        Duration overallTimeout() {
            return this.overallTimeout;
        }

        LazyValue<? extends ScheduledExecutorService> scheduledExecutor() {
            return this.scheduledExecutor;
        }

        String name() {
            return this.name;
        }

        boolean cancelSource() {
            return this.cancelSource;
        }
    }
}

