/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.faulttolerance.DelayedTask;
import io.helidon.faulttolerance.ErrorChecker;
import io.helidon.faulttolerance.Fallback;
import io.helidon.faulttolerance.FaultTolerance;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.function.Supplier;

class FallbackImpl<T>
implements Fallback<T> {
    private final Function<Throwable, ? extends CompletionStage<T>> fallback;
    private final Function<Throwable, ? extends Flow.Publisher<T>> fallbackMulti;
    private final ErrorChecker errorChecker;

    FallbackImpl(Fallback.Builder<T> builder) {
        this.fallback = builder.fallback();
        this.fallbackMulti = builder.fallbackMulti();
        this.errorChecker = ErrorChecker.create(builder.skipOn(), builder.applyOn());
    }

    @Override
    public Multi<T> invokeMulti(Supplier<? extends Flow.Publisher<T>> supplier) {
        DelayedTask delayedTask = DelayedTask.createMulti(supplier);
        delayedTask.execute();
        return delayedTask.result().onErrorResumeWith(throwable -> {
            Throwable cause = FaultTolerance.cause(throwable);
            if (delayedTask.hadData() || this.errorChecker.shouldSkip(cause)) {
                return Multi.error((Throwable)cause);
            }
            return Multi.create(this.fallbackMulti.apply(cause)).onErrorResumeWith(t2 -> {
                t2.addSuppressed(new CompletionException((Throwable)throwable));
                return Multi.error((Throwable)t2);
            });
        });
    }

    @Override
    public Single<T> invoke(Supplier<? extends CompletionStage<T>> supplier) {
        CompletableFuture future = new CompletableFuture();
        supplier.get().thenAccept(future::complete).exceptionally(throwable -> {
            Throwable cause = FaultTolerance.cause(throwable);
            if (this.errorChecker.shouldSkip(cause)) {
                future.completeExceptionally(cause);
            } else {
                this.fallback.apply(cause).thenAccept(future::complete).exceptionally(t2 -> {
                    Throwable cause2 = FaultTolerance.cause(t2);
                    cause2.addSuppressed((Throwable)throwable);
                    future.completeExceptionally(cause2);
                    return null;
                });
            }
            return null;
        });
        return Single.create(future, (boolean)true);
    }
}

