/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.common.LazyValue;
import io.helidon.common.reactive.Single;
import io.helidon.faulttolerance.AsyncImpl;
import io.helidon.faulttolerance.FaultTolerance;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public interface Async {
    public <T> Single<T> invoke(Supplier<T> var1);

    public static Async create() {
        return AsyncImpl.DefaultAsyncInstance.instance();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements io.helidon.common.Builder<Async> {
        private LazyValue<? extends ExecutorService> executor = FaultTolerance.executor();

        private Builder() {
        }

        public Async build() {
            return new AsyncImpl(this);
        }

        public Builder executor(Supplier<? extends ExecutorService> executor) {
            this.executor = LazyValue.create(Objects.requireNonNull(executor));
            return this;
        }

        public Builder executor(ExecutorService executor) {
            this.executor = LazyValue.create((Object)Objects.requireNonNull(executor));
            return this;
        }

        LazyValue<? extends ExecutorService> executor() {
            return this.executor;
        }
    }
}

