/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.server;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.extension.ExtensionWriter;
import io.smallrye.openapi.runtime.io.servervariable.ServerVariableWriter;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.servers.ServerVariable;

public class ServerWriter {
    private ServerWriter() {
    }

    public static void writeServers(ObjectNode node, List<Server> servers) {
        if (servers == null) {
            return;
        }
        ArrayNode array = node.putArray("servers");
        for (Server server : servers) {
            ObjectNode serverNode = array.addObject();
            ServerWriter.writeServerToNode(serverNode, server);
        }
    }

    public static void writeServer(ObjectNode parent, Server model) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject("server");
        ServerWriter.writeServerToNode(node, model);
    }

    private static void writeServerToNode(ObjectNode node, Server model) {
        JsonUtil.stringProperty(node, "url", model.getUrl());
        JsonUtil.stringProperty(node, "description", model.getDescription());
        ServerVariableWriter.writeServerVariables(node, (Map<String, ServerVariable>)model.getVariables());
        ExtensionWriter.writeExtensions(node, model);
    }
}

