/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.staticcontent;

import io.helidon.common.http.Http;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.staticcontent.FileBasedContentHandler;
import io.helidon.webserver.staticcontent.StaticContentSupport;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.logging.Logger;

class FileSystemContentHandler
extends FileBasedContentHandler {
    private static final Logger LOGGER = Logger.getLogger(FileSystemContentHandler.class.getName());
    private final Path root;

    FileSystemContentHandler(StaticContentSupport.FileSystemBuilder builder) {
        super(builder);
        this.root = builder.root();
    }

    @Override
    boolean doHandle(Http.RequestMethod method, String requestedPath, ServerRequest request, ServerResponse response) throws IOException {
        Path resolved;
        if (requestedPath.isEmpty()) {
            resolved = this.root;
        } else {
            resolved = this.root.resolve(requestedPath).normalize();
            LOGGER.finest(() -> "Requested file: " + String.valueOf(resolved.toAbsolutePath()));
            if (!resolved.startsWith(this.root)) {
                return false;
            }
        }
        return this.doHandle(method, resolved, request, response);
    }

    boolean doHandle(Http.RequestMethod method, Path path, ServerRequest request, ServerResponse response) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        this.sendFile(method, path, request, response, this.welcomePageName());
        return true;
    }
}

