/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.staticcontent;

import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.media.common.DefaultMediaSupport;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.webserver.HttpException;
import io.helidon.webserver.RequestHeaders;
import io.helidon.webserver.ResponseHeaders;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.staticcontent.StaticContentHandler;
import io.helidon.webserver.staticcontent.StaticContentSupport;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;

abstract class FileBasedContentHandler
extends StaticContentHandler {
    private static final Logger LOGGER = Logger.getLogger(FileBasedContentHandler.class.getName());
    private static final MessageBodyWriter<Path> PATH_WRITER = DefaultMediaSupport.pathWriter();
    private final Map<String, MediaType> customMediaTypes;

    FileBasedContentHandler(StaticContentSupport.FileBasedBuilder<?> builder) {
        super(builder);
        this.customMediaTypes = builder.specificContentTypes();
    }

    static String fileName(Path path) {
        Path fileName = path.getFileName();
        if (null == fileName) {
            return "";
        }
        return fileName.toString();
    }

    private static Path resolveWelcomeFile(Path directory, String name) {
        FileBasedContentHandler.throwNotFoundIf(name == null || name.isEmpty());
        Path result = directory.resolve(name);
        FileBasedContentHandler.throwNotFoundIf(!Files.exists(result, new LinkOption[0]));
        return result;
    }

    void processContentType(String filename, RequestHeaders requestHeaders, ResponseHeaders responseHeaders) {
        responseHeaders.contentType(this.detectType(filename, requestHeaders));
    }

    private MediaType detectType(String fileName, RequestHeaders requestHeaders) {
        Objects.requireNonNull(fileName);
        Objects.requireNonNull(requestHeaders);
        return this.findCustomMediaType(fileName).or(() -> MediaTypes.detectType((String)fileName).map(MediaType::parse)).map(it -> {
            if (requestHeaders.isAccepted(it)) {
                return it;
            }
            throw new HttpException("Media type " + String.valueOf(it) + " is not accepted by request", (Http.ResponseStatus)Http.Status.UNSUPPORTED_MEDIA_TYPE_415);
        }).orElseGet(() -> {
            List acceptedTypes = requestHeaders.acceptedTypes();
            if (acceptedTypes.isEmpty()) {
                return MediaType.APPLICATION_OCTET_STREAM;
            }
            return (MediaType)acceptedTypes.iterator().next();
        });
    }

    Optional<MediaType> findCustomMediaType(String fileName) {
        int ind = fileName.lastIndexOf(46);
        if (ind < 0) {
            return Optional.empty();
        }
        String fileSuffix = fileName.substring(ind + 1);
        return Optional.ofNullable(this.customMediaTypes.get(fileSuffix));
    }

    void sendFile(Http.RequestMethod method, Path pathParam, ServerRequest request, ServerResponse response, String welcomePage) throws IOException {
        LOGGER.fine(() -> "Sending static content from file: " + String.valueOf(pathParam));
        Path path = pathParam;
        if (Files.isDirectory(path, new LinkOption[0])) {
            String rawFullPath = request.uri().getRawPath();
            if (rawFullPath.endsWith("/")) {
                path = FileBasedContentHandler.resolveWelcomeFile(path, welcomePage);
            } else {
                FileBasedContentHandler.redirect(request, response, rawFullPath + "/");
                return;
            }
        }
        if (!Files.isRegularFile(path, new LinkOption[0]) || !Files.isReadable(path) || Files.isHidden(path)) {
            throw new HttpException("File is not accessible", (Http.ResponseStatus)Http.Status.FORBIDDEN_403);
        }
        try {
            Instant lastMod = Files.getLastModifiedTime(path, new LinkOption[0]).toInstant();
            FileBasedContentHandler.processEtag(String.valueOf(lastMod.toEpochMilli()), request.headers(), response.headers());
            FileBasedContentHandler.processModifyHeaders(lastMod, request.headers(), response.headers());
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
        this.processContentType(FileBasedContentHandler.fileName(path), request.headers(), response.headers());
        if (method == Http.Method.HEAD) {
            response.send();
        } else {
            this.send(response, path);
        }
    }

    void send(ServerResponse response, Path path) {
        response.send(PATH_WRITER.marshall((Object)path));
    }
}

