/*
 * Decompiled with CFR 0.152.
 */
package weblogic.console.utils;

public class StringUtils {
    public static boolean equals(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static boolean notEmpty(String string) {
        return !StringUtils.isEmpty(string);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static String nonEmpty(String string) {
        return StringUtils.notEmpty(string) ? string : null;
    }

    public static String nonNull(String string) {
        return StringUtils.notEmpty(string) ? string : "";
    }

    public static String getSingular(String plural) {
        String singular = StringUtils.replaceEnding(plural, "sses", "ss");
        if (singular == null) {
            singular = StringUtils.replaceEnding(plural, "ies", "y");
        }
        if (singular == null) {
            singular = StringUtils.replaceEnding(plural, "s", "");
        }
        if (singular == null) {
            singular = plural;
        }
        return singular;
    }

    private static boolean isVowel(String letter) {
        return "aeiou".contains(letter);
    }

    public static String getPlural(String singular) {
        if (singular.endsWith("s") && !singular.endsWith("ss")) {
            return singular;
        }
        String plural = StringUtils.replaceEnding(singular, "ss", "sses");
        if (plural == null) {
            int len = singular.length();
            if (singular.endsWith("y") && !StringUtils.isVowel(singular.substring(len - 2, len - 1))) {
                plural = StringUtils.replaceEnding(singular, "y", "ies");
            } else if (singular.endsWith("ch") || singular.endsWith("sh") || singular.endsWith("x") || singular.endsWith("z")) {
                plural = singular + "es";
            }
        }
        if (plural == null) {
            plural = singular + "s";
        }
        return plural;
    }

    public static String camelCaseToUpperCaseWords(String camelCase) {
        return StringUtils.lowerCaseWordsToUpperCaseWords(StringUtils.camelCaseToLowerCaseWords(camelCase));
    }

    public static String lowerCaseWordsToUpperCaseWords(String lowerCaseWords) {
        if (lowerCaseWords == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean inWord = false;
        for (int i = 0; i < lowerCaseWords.length(); ++i) {
            char c = lowerCaseWords.charAt(i);
            if (c == ' ') {
                inWord = false;
            } else {
                if (!inWord) {
                    c = Character.toUpperCase(c);
                }
                inWord = true;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String camelCaseToLowerCaseWords(String camelCase) {
        if (camelCase == null) {
            return null;
        }
        if (camelCase.contains("SurName")) {
            camelCase = camelCase.replace("SurName", "Surname");
        }
        StringBuilder sb = new StringBuilder();
        int start = 0;
        boolean emitWord = false;
        for (int i = 0; i < camelCase.length(); ++i) {
            char c = camelCase.charAt(i);
            if (i == 0) continue;
            char lastChar = camelCase.charAt(i - 1);
            char secondToLastChar = i >= 2 ? camelCase.charAt(i - 2) : (char)'\u0000';
            boolean isLetter = Character.isLetter(c);
            boolean isUpperCase = Character.isUpperCase(c);
            boolean wasLetter = Character.isLetter(lastChar);
            boolean wasUpperCase = Character.isUpperCase(lastChar);
            boolean wasA = lastChar == 'A';
            boolean secondToLastIsUpper = Character.isUpperCase(secondToLastChar);
            char nextChar = i + 1 < camelCase.length() ? camelCase.charAt(i + 1) : (char)'\u0000';
            boolean nextIsUpper = Character.isUpperCase(nextChar);
            if (isUpperCase) {
                if (wasUpperCase && (!wasA || secondToLastIsUpper) || wasA && secondToLastIsUpper || wasA && nextIsUpper || wasA && nextChar == 's' || !wasLetter) continue;
                StringUtils.emitWord(sb, camelCase, start, i);
                start = i;
                continue;
            }
            if (isLetter) {
                if (wasUpperCase) {
                    int length = i - start;
                    if (length == 0) {
                        throw new AssertionError((Object)("Only the first word can start with a lower case letter: " + camelCase + " " + start));
                    }
                    if (length == 1 || length == 2) continue;
                    StringUtils.emitWord(sb, camelCase, start, i - 1);
                    start = i - 1;
                    continue;
                }
                if (!wasLetter) continue;
                continue;
            }
            if (!wasUpperCase && !wasLetter) continue;
        }
        StringUtils.emitWord(sb, camelCase, start, camelCase.length());
        return sb.toString();
    }

    public static String toCamelCase(String s) {
        return StringUtils.toCamelCase(s, "_");
    }

    public static String toCamelCase(String s, String delim) {
        String[] parts = new String[]{s};
        if (!StringUtils.isEmpty(delim)) {
            parts = s.split("[" + delim + "]");
        }
        String camelCaseString = "";
        for (String part : parts) {
            camelCaseString = camelCaseString + StringUtils.toProperCase(part);
        }
        return camelCaseString;
    }

    public static String toProperCase(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static String getBeanName(String restName) {
        if (StringUtils.isEmpty(restName)) {
            return restName;
        }
        return restName.substring(0, 1).toUpperCase() + restName.substring(1);
    }

    public static String getRestName(String beanName) {
        int count;
        if (beanName == null) {
            return beanName;
        }
        for (count = 0; count < beanName.length() && Character.isUpperCase(beanName.charAt(count)); ++count) {
        }
        if (count == beanName.length()) {
            return beanName;
        }
        if (count == 0) {
            return beanName;
        }
        if (count == 1) {
            return beanName.substring(0, count).toLowerCase() + beanName.substring(count);
        }
        return beanName;
    }

    public static String getSimpleTypeName(String className) {
        return StringUtils.removeSuffix(StringUtils.getLeafClassName(className), "MBean", "DBean", "Bean");
    }

    public static String getLeafClassName(String className) {
        className = StringUtils.nonNull(className);
        return className.substring(className.lastIndexOf(".") + 1);
    }

    public static String removeSuffix(String str, String ... suffixes) {
        for (String suffix : suffixes) {
            if (!str.endsWith(suffix)) continue;
            return str.substring(0, str.length() - suffix.length());
        }
        return str;
    }

    public static boolean isInteger(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static void emitWord(StringBuilder sb, String s, int start, int end) {
        boolean firstWord;
        if (start > end) {
            throw new AssertionError((Object)("Start greater than end: " + s + " " + start + " " + end));
        }
        if (start == end) {
            return;
        }
        String word = s.substring(start, end);
        boolean isAcronym = false;
        int length = word.length();
        isAcronym = length > 1 ? !Character.isLowerCase(word.charAt(1)) : false;
        if (!isAcronym) {
            word = StringUtils.fixSpelling(word.toLowerCase());
        }
        boolean bl = firstWord = start == 0;
        if (!firstWord) {
            sb.append(" ");
        }
        sb.append(word);
    }

    private static String fixSpelling(String word) {
        switch (word) {
            case "submited": {
                return "submitted";
            }
            case "joinpoint": {
                return "join point";
            }
        }
        return word;
    }

    private static String replaceEnding(String plural, String pluralEnding, String singularEnding) {
        if (plural.endsWith(pluralEnding)) {
            return plural.substring(0, plural.length() - pluralEnding.length()) + singularEnding;
        }
        return null;
    }

    public static String cleanStringForLogging(Object string) {
        if (string == null) {
            return null;
        }
        return string.toString().replaceAll("[^A-Za-z0-9_]", " ");
    }
}

