/*
 * Decompiled with CFR 0.152.
 */
package weblogic.console.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import weblogic.console.utils.Deduplicatable;
import weblogic.console.utils.StringUtils;

public class Path
implements Comparable,
Deduplicatable {
    private List<String> components = new ArrayList<String>();

    public Path() {
    }

    public Path(String dotSeparatedPath) {
        this(StringUtils.notEmpty(dotSeparatedPath) ? dotSeparatedPath.split("\\.") : (String[])null);
    }

    public Path(Path toClone) {
        this(toClone.getComponents());
    }

    public Path clone() {
        return new Path(this);
    }

    public Path childPath(String component) {
        Path rtn = this.clone();
        rtn.addComponent(component);
        return rtn;
    }

    public Path childPath(Path child) {
        Path rtn = this.clone();
        rtn.addComponents(child.getComponents());
        return rtn;
    }

    public Path subPath(int fromIndex, int toIndex) {
        if (toIndex == -1) {
            toIndex = this.getComponents().size();
        }
        return new Path(this.getComponents().subList(fromIndex, toIndex));
    }

    private Path(String[] components) {
        this.addComponents(components);
    }

    private Path(List<String> components) {
        this.addComponents(components);
    }

    public void addPath(Path path) {
        this.addComponents(path.getComponents());
    }

    public void addComponents(String ... components) {
        this.addComponents(components != null ? Arrays.asList(components) : (List)null);
    }

    public void addComponents(List<String> components) {
        if (components != null) {
            for (String component : components) {
                this.addComponent(component);
            }
        }
    }

    public void addComponent(String component) {
        if (StringUtils.notEmpty(component)) {
            this.components.add(component);
        }
    }

    public String getLastComponent() {
        if (this.getComponents().isEmpty()) {
            return null;
        }
        return this.getComponents().get(this.getComponents().size() - 1);
    }

    public String getFirstComponent() {
        if (this.getComponents().isEmpty()) {
            return null;
        }
        return this.getComponents().get(0);
    }

    public List<String> getComponents() {
        return this.components;
    }

    public Path getParent() {
        Path parent = new Path();
        for (int i = 0; i < this.getComponents().size() - 1; ++i) {
            parent.addComponent(this.getComponents().get(i));
        }
        return parent;
    }

    public String getUnderscoreSeparatedPath() {
        return this.getSeparatedPath("_");
    }

    public String getDotSeparatedPath() {
        return this.getSeparatedPath(".");
    }

    public String getSlashSeparatedPath() {
        return this.getSeparatedPath("/");
    }

    public String getSeparatedPath(String separator) {
        return this.getPath(this.getComponents(), separator);
    }

    public boolean isEmpty() {
        return this.getComponents().isEmpty();
    }

    public int length() {
        return this.getComponents().size();
    }

    private String getPath(List<String> components, String separator) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String component : components) {
            if (!first) {
                sb.append(separator);
            }
            sb.append(component);
            first = false;
        }
        return sb.toString();
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        Path path = (Path)Path.class.cast(obj);
        List<String> lhs = this.getComponents();
        List<String> rhs = path.getComponents();
        int size = Math.min(lhs.size(), rhs.size());
        for (int i = 0; i < size; ++i) {
            int comp = lhs.get(i).compareTo(rhs.get(i));
            if (comp == 0) continue;
            return comp;
        }
        if (lhs.size() == size && rhs.size() == size) {
            return 0;
        }
        if (lhs.size() > size) {
            return 1;
        }
        return -1;
    }

    public int hashCode() {
        int result = 1;
        for (String component : this.getComponents()) {
            result *= component.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!Path.class.isInstance(obj)) {
            return false;
        }
        Path other = (Path)Path.class.cast(obj);
        List<String> lhs = this.getComponents();
        List<String> rhs = other.getComponents();
        if (lhs.size() != rhs.size()) {
            return false;
        }
        for (int i = 0; i < lhs.size(); ++i) {
            if (lhs.get(i).equals(rhs.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getDotSeparatedPath();
    }

    @Override
    public String getDeduplicationKey() {
        return this.toString();
    }
}

