/*
 * Decompiled with CFR 0.152.
 */
package weblogic.console.schema;

import java.util.List;
import weblogic.console.utils.Path;

public class YamlSource {
    private String yamlFile;
    private Path path;

    public void validateExtension(String yamlFile) {
        this.validateExtension(yamlFile, new Path());
    }

    protected void validateExtension(String yamlFile, Path path) {
        this.yamlFile = yamlFile;
        this.path = path;
        this.validateExtension();
        this.yamlFile = null;
        this.path = null;
    }

    protected void validateExtension() {
    }

    protected void validateExtensionChild(YamlSource child, String childName) {
        if (child != null) {
            child.validateExtension(this.yamlFile, this.path.childPath(childName));
        }
    }

    protected <T extends YamlSource> void validateExtensionChildren(List<T> children, String childrenName) {
        if (children != null) {
            for (YamlSource child : children) {
                this.validateExtensionChild(child, childrenName);
            }
        }
    }

    protected void validateExtensionStringPropertyNotSpecified(String val, String property) {
        if (val != null && !val.isEmpty()) {
            this.extensionPropertySpecifiedError(property);
        }
    }

    protected void extensionPropertySpecifiedError(String property) {
        this.extensionPropertyError(property, "must not be specified");
    }

    protected void extensionPropertyError(String property, String error) {
        throw new AssertionError((Object)("Extension yaml error: " + this.yamlFile + " " + this.path.childPath(property) + " " + error));
    }
}

