/*
 * Decompiled with CFR 0.152.
 */
package weblogic.console.schema;

import weblogic.console.schema.ReadOnlyValue;
import weblogic.console.utils.Deduplicator;
import weblogic.console.utils.Path;

public class Value<T>
extends ReadOnlyValue<T> {
    private static final Deduplicator DEDUPLICATOR = new Deduplicator("Value");

    private Value(T defaultValue, T yamlValue, boolean specifiedInYaml, Path containedBeanPath) {
        super(defaultValue, yamlValue, specifiedInYaml, containedBeanPath);
    }

    public static <T> Value<T> create() {
        return Value.create(null);
    }

    public static <T> Value<T> create(T defaultValue) {
        return Value.create(defaultValue, null, false, new Path());
    }

    private static <T> Value<T> create(T defaultValue, T yamlValue, boolean specifiedInYaml, Path containedBeanPath) {
        return DEDUPLICATOR.deduplicate(new Value<T>(defaultValue, yamlValue, specifiedInYaml, containedBeanPath));
    }

    public Value<T> setValue(T value) {
        this.validateValue(value);
        return Value.create(this.getDefaultValue(), value, true, this.getContainedBeanPath());
    }

    public Value<T> copyFrom(Value<T> from, Path fromContainedBeanPath) {
        return Value.create(this.getDefaultValue(), from.getValue(), from.isSpecifiedInYaml(), fromContainedBeanPath.childPath(from.getContainedBeanPath()));
    }

    public Value<T> merge(Value<T> from, Path fromContainedBeanPath) {
        if (from.isSpecifiedInYaml()) {
            return this.copyFrom(from, fromContainedBeanPath);
        }
        return this;
    }

    @Override
    protected String getValueKey(T value) {
        if (value == null) {
            return "null";
        }
        return null;
    }
}

