/*
 * Decompiled with CFR 0.152.
 */
package weblogic.console.schema;

import java.util.ArrayList;
import java.util.List;
import weblogic.console.schema.ReadOnlyValue;
import weblogic.console.schema.ScalarUtils;
import weblogic.console.utils.Deduplicator;
import weblogic.console.utils.Path;

public class ScalarValues
extends ReadOnlyValue<List<Object>> {
    private static final Deduplicator<ScalarValues> DEDUPLICATOR = new Deduplicator("ScalarsValue");

    private ScalarValues(List<Object> defaultValue, List<Object> yamlValue, boolean specifiedInYaml, Path containedBeanPath) {
        super(defaultValue, yamlValue, specifiedInYaml, containedBeanPath);
    }

    public static <T> ScalarValues create() {
        return ScalarValues.create(new ArrayList<Object>());
    }

    public static <T> ScalarValues create(List<Object> defaultValue) {
        return ScalarValues.create(defaultValue, null, false, new Path());
    }

    private static <T> ScalarValues create(List<Object> defaultValue, List<Object> yamlValue, boolean specifiedInYaml, Path containedBeanPath) {
        return DEDUPLICATOR.deduplicate(new ScalarValues(defaultValue, yamlValue, specifiedInYaml, containedBeanPath));
    }

    public ScalarValues setValue(List<Object> value) {
        this.validateValue(value);
        return ScalarValues.create((List)this.getDefaultValue(), value, true, this.getContainedBeanPath());
    }

    public ScalarValues add(Object value) {
        List currentValue = (List)this.getValue();
        ArrayList<Object> newValue = currentValue != null ? new ArrayList<Object>(currentValue) : new ArrayList();
        newValue.add(value);
        return this.setValue(newValue);
    }

    public ScalarValues copyFrom(ScalarValues from, Path fromContainedBeanPath) {
        return ScalarValues.create((List)this.getDefaultValue(), (List)from.getValue(), from.isSpecifiedInYaml(), fromContainedBeanPath.childPath(from.getContainedBeanPath()));
    }

    public ScalarValues merge(ScalarValues from, Path fromContainedBeanPath) {
        if (from.isSpecifiedInYaml()) {
            return this.copyFrom(from, fromContainedBeanPath);
        }
        return this;
    }

    @Override
    protected String getValueKey(List<Object> value) {
        if (value == null) {
            return "null";
        }
        if (value.isEmpty()) {
            return "empty";
        }
        return null;
    }

    @Override
    protected void validateValue(List<Object> value) {
        super.validateValue(value);
        ScalarUtils.validateScalars(value);
    }
}

