/*
 * Decompiled with CFR 0.152.
 */
package weblogic.console.schema;

import weblogic.console.schema.ReadOnlyValue;
import weblogic.console.schema.ScalarUtils;
import weblogic.console.utils.Deduplicator;
import weblogic.console.utils.Path;

public class ScalarValue
extends ReadOnlyValue<Object> {
    private static final Deduplicator<ScalarValue> DEDUPLICATOR = new Deduplicator("ScalarValue");

    private ScalarValue(Object defaultValue, Object yamlValue, boolean specifiedInYaml, Path containedBeanPath) {
        super(defaultValue, yamlValue, specifiedInYaml, containedBeanPath);
    }

    public static ScalarValue create() {
        return ScalarValue.create(false);
    }

    public static ScalarValue create(Object defaultValue) {
        return ScalarValue.create(defaultValue, null, false, new Path());
    }

    private static ScalarValue create(Object defaultValue, Object yamlValue, boolean specifiedInYaml, Path containedBeanPath) {
        return DEDUPLICATOR.deduplicate(new ScalarValue(defaultValue, yamlValue, specifiedInYaml, containedBeanPath));
    }

    public ScalarValue setValue(Object value) {
        this.validateValue(value);
        return ScalarValue.create(this.getDefaultValue(), value, true, this.getContainedBeanPath());
    }

    public ScalarValue copyFrom(ScalarValue from, Path fromContainedBeanPath) {
        return ScalarValue.create(this.getDefaultValue(), from.getValue(), from.isSpecifiedInYaml(), fromContainedBeanPath.childPath(from.getContainedBeanPath()));
    }

    public ScalarValue merge(ScalarValue from, Path fromContainedBeanPath) {
        if (from.isSpecifiedInYaml()) {
            return this.copyFrom(from, fromContainedBeanPath);
        }
        return this;
    }

    @Override
    public String getValueKey(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "string<" + value.toString() + ">";
        }
        return null;
    }

    @Override
    protected void validateValue(Object value) {
        ScalarUtils.validateScalar(value);
    }
}

