/*
 * Decompiled with CFR 0.152.
 */
package weblogic.console.schema;

import weblogic.console.utils.Deduplicatable;
import weblogic.console.utils.Deduplicator;
import weblogic.console.utils.Path;

public class ReadOnlyValue<T>
implements Deduplicatable {
    private static final Deduplicator<Path> DEDUPLICATOR = new Deduplicator("Path");
    private T defaultValue;
    private T yamlValue;
    private boolean specifiedInYaml;
    private Path containedBeanPath = new Path();

    public ReadOnlyValue(T defaultValue, T yamlValue, boolean specifiedInYaml, Path containedBeanPath) {
        this.defaultValue = defaultValue;
        this.yamlValue = yamlValue;
        this.specifiedInYaml = specifiedInYaml;
        this.containedBeanPath = DEDUPLICATOR.deduplicate(containedBeanPath);
    }

    public boolean isSpecifiedInYaml() {
        return this.specifiedInYaml;
    }

    public Path getContainedBeanPath() {
        return this.containedBeanPath;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getYamlValue() {
        return this.yamlValue;
    }

    public T getValue() {
        return this.isSpecifiedInYaml() ? this.getYamlValue() : this.getDefaultValue();
    }

    protected void validateValue(T value) {
        if (value == null) {
            throw new AssertionError((Object)"yaml error. The value cannot be set to null");
        }
    }

    @Override
    public String getDeduplicationKey() {
        String defaultValueKey = this.getValueKey(this.getDefaultValue());
        if (defaultValueKey == null) {
            return null;
        }
        String yamlValueKey = this.getValueKey(this.getYamlValue());
        if (yamlValueKey == null) {
            return null;
        }
        return "defaultValue<" + defaultValueKey + ">yamlValue<" + yamlValueKey + ">specifiedInYaml<" + this.isSpecifiedInYaml() + ">containedBeanPath<" + this.getContainedBeanPath() + ">";
    }

    protected String getValueKey(T value) {
        if (value == null) {
            return "null";
        }
        return "value<" + value.toString() + ">";
    }
}

