/*
 * Decompiled with CFR 0.152.
 */
package weblogic.console.schema;

import weblogic.console.schema.ReadOnlyValue;
import weblogic.console.utils.Deduplicator;
import weblogic.console.utils.Path;

public class NullableValue<T>
extends ReadOnlyValue<T> {
    private static final Deduplicator DEDUPLICATOR = new Deduplicator("NullableValue");

    private NullableValue(T defaultValue, T yamlValue, boolean specifiedInYaml, Path containedBeanPath) {
        super(defaultValue, yamlValue, specifiedInYaml, containedBeanPath);
    }

    public static <T> NullableValue<T> create() {
        return NullableValue.create(null);
    }

    public static <T> NullableValue<T> create(T defaultValue) {
        return NullableValue.create(defaultValue, null, false, new Path());
    }

    private static <T> NullableValue<T> create(T defaultValue, T yamlValue, boolean specifiedInYaml, Path containedBeanPath) {
        return DEDUPLICATOR.deduplicate(new NullableValue<T>(defaultValue, yamlValue, specifiedInYaml, containedBeanPath));
    }

    public NullableValue<T> setValue(T value) {
        this.validateValue(value);
        return NullableValue.create(this.getDefaultValue(), value, true, this.getContainedBeanPath());
    }

    public NullableValue<T> copyFrom(NullableValue<T> from, Path fromContainedBeanPath) {
        return NullableValue.create(this.getDefaultValue(), from.getValue(), from.isSpecifiedInYaml(), fromContainedBeanPath.childPath(from.getContainedBeanPath()));
    }

    public NullableValue<T> merge(NullableValue<T> from, Path fromContainedBeanPath) {
        if (from.isSpecifiedInYaml()) {
            return this.copyFrom(from, fromContainedBeanPath);
        }
        return this;
    }

    @Override
    protected String getValueKey(T value) {
        if (value == null) {
            return "null";
        }
        return null;
    }

    @Override
    protected void validateValue(T value) {
    }
}

