/*
 * Decompiled with CFR 0.152.
 */
package weblogic.console.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import weblogic.console.schema.ReadOnlyValue;
import weblogic.console.utils.Deduplicator;
import weblogic.console.utils.Path;

public class ListValue<T>
extends ReadOnlyValue<List<T>> {
    private static final Deduplicator DEDUPLICATOR = new Deduplicator("ListValue");

    private ListValue(List<T> defaultValue, List<T> yamlValue, boolean specifiedInYaml, Path containedBeanPath) {
        super(ListValue.toReadOnly(defaultValue), ListValue.toReadOnly(yamlValue), specifiedInYaml, containedBeanPath);
    }

    private static <T> List<T> toReadOnly(List<T> list) {
        return list != null ? Collections.unmodifiableList(list) : null;
    }

    public static <T> ListValue<T> create() {
        return ListValue.create(new ArrayList());
    }

    public static <T> ListValue<T> create(List<T> defaultValue) {
        return ListValue.create(defaultValue, null, false, new Path());
    }

    private static <T> ListValue<T> create(List<T> defaultValue, List<T> yamlValue, boolean specifiedInYaml, Path containedBeanPath) {
        return DEDUPLICATOR.deduplicate(new ListValue<T>(defaultValue, yamlValue, specifiedInYaml, containedBeanPath));
    }

    public ListValue<T> setValue(List<T> value) {
        this.validateValue(value);
        return ListValue.create((List)this.getDefaultValue(), value, true, this.getContainedBeanPath());
    }

    public ListValue<T> add(T value) {
        List currentValue = (List)this.getValue();
        ArrayList<T> newValue = currentValue != null ? new ArrayList<T>(currentValue) : new ArrayList();
        newValue.add(value);
        return this.setValue(newValue);
    }

    public ListValue<T> copyFrom(ListValue<T> from, Path fromContainedBeanPath) {
        return ListValue.create((List)this.getDefaultValue(), (List)from.getValue(), from.isSpecifiedInYaml(), fromContainedBeanPath.childPath(from.getContainedBeanPath()));
    }

    public ListValue<T> merge(ListValue<T> from, Path fromContainedBeanPath) {
        if (from.isSpecifiedInYaml()) {
            return this.copyFrom(from, fromContainedBeanPath);
        }
        return this;
    }

    @Override
    protected String getValueKey(List<T> value) {
        if (value == null) {
            return "null";
        }
        if (value.isEmpty()) {
            return "empty";
        }
        return null;
    }
}

