/*
 * Decompiled with CFR 0.152.
 */
package weblogic.console.schema;

import weblogic.console.schema.ReadOnlyValue;
import weblogic.console.utils.Deduplicator;
import weblogic.console.utils.Path;

public class BooleanValue
extends ReadOnlyValue<Boolean> {
    private static final Deduplicator<BooleanValue> DEDUPLICATOR = new Deduplicator("BooleanValue");

    private BooleanValue(Boolean defaultValue, Boolean yamlValue, boolean specifiedInYaml, Path containedBeanPath) {
        super(defaultValue, yamlValue, specifiedInYaml, containedBeanPath);
    }

    public static BooleanValue create() {
        return BooleanValue.create(false);
    }

    public static BooleanValue create(Boolean defaultValue) {
        return BooleanValue.create(defaultValue, null, false, new Path());
    }

    private static BooleanValue create(Boolean defaultValue, Boolean yamlValue, boolean specifiedInYaml, Path containedBeanPath) {
        return DEDUPLICATOR.deduplicate(new BooleanValue(defaultValue, yamlValue, specifiedInYaml, containedBeanPath));
    }

    public BooleanValue setValue(Boolean value) {
        this.validateValue(value);
        return BooleanValue.create((Boolean)this.getDefaultValue(), value, true, this.getContainedBeanPath());
    }

    public BooleanValue copyFrom(BooleanValue from, Path fromContainedBeanPath) {
        return BooleanValue.create((Boolean)this.getDefaultValue(), (Boolean)from.getValue(), from.isSpecifiedInYaml(), fromContainedBeanPath.childPath(from.getContainedBeanPath()));
    }

    public BooleanValue merge(BooleanValue from, Path fromContainedBeanPath) {
        if (from.isSpecifiedInYaml()) {
            return this.copyFrom(from, fromContainedBeanPath);
        }
        return this;
    }
}

