/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

class PathHelper {
    private PathHelper() {
    }

    static String canonicalize(String p) {
        if (p == null || p.isEmpty() || p.equals("/")) {
            return "/";
        }
        int lastCharIndex = p.length() - 1;
        return p.charAt(lastCharIndex) == '/' ? p.substring(0, lastCharIndex) : p;
    }

    static String extractPathParams(String path) {
        if (!path.contains(";")) {
            return path;
        }
        State state = State.NORMAL;
        int n = path.length();
        StringBuilder builder = new StringBuilder(n);
        block5: for (int i = 0; i < n; ++i) {
            char ch = path.charAt(i);
            switch (ch) {
                case ';': {
                    if (state != State.NORMAL) continue block5;
                    state = State.PATH_PARAM;
                    continue block5;
                }
                case '/': {
                    if (state == State.QUERY_PARAM) {
                        throw new IllegalStateException("Unexpected state " + String.valueOf((Object)state));
                    }
                    state = State.NORMAL;
                    builder.append(ch);
                    continue block5;
                }
                case '?': {
                    state = State.QUERY_PARAM;
                    builder.append(ch);
                    continue block5;
                }
                default: {
                    if (state == State.PATH_PARAM) continue block5;
                    builder.append(ch);
                }
            }
        }
        return PathHelper.canonicalize(builder.toString());
    }

    private static enum State {
        NORMAL,
        PATH_PARAM,
        QUERY_PARAM;

    }
}

