/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Http;
import io.helidon.common.reactive.IoMulti;
import io.helidon.webserver.ContentTypeSelector;
import io.helidon.webserver.FileSystemContentHandler;
import io.helidon.webserver.HttpException;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.StaticContentHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Flow;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;

@Deprecated
class ClassPathContentHandler
extends StaticContentHandler {
    private static final Logger LOGGER = Logger.getLogger(ClassPathContentHandler.class.getName());
    private final ClassLoader classLoader;
    private final Map<String, ExtractedJarEntry> extracted = new ConcurrentHashMap<String, ExtractedJarEntry>();
    private final String root;
    private final String rootWithTrailingSlash;
    private final Path tempDir;

    ClassPathContentHandler(String welcomeFilename, ContentTypeSelector contentTypeSelector, String root, Path tempDir, ClassLoader classLoader) {
        super(welcomeFilename, contentTypeSelector);
        this.classLoader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
        this.tempDir = tempDir;
        this.root = root;
        this.rootWithTrailingSlash = root + "/";
    }

    public static StaticContentHandler create(String welcomeFileName, ContentTypeSelector selector, String clRoot, Path tempDir, ClassLoader classLoader) {
        ClassLoader contentClassloader = classLoader == null ? ClassPathContentHandler.class.getClassLoader() : classLoader;
        String cleanRoot = clRoot;
        while (cleanRoot.endsWith("/")) {
            cleanRoot = clRoot.substring(0, cleanRoot.length() - 1);
        }
        if (cleanRoot.isEmpty()) {
            throw new IllegalArgumentException("Cannot serve full classpath, please configure a classpath prefix");
        }
        return new ClassPathContentHandler(welcomeFileName, selector, clRoot, tempDir, contentClassloader);
    }

    @Override
    boolean doHandle(Http.RequestMethod method, String requestedPath, ServerRequest request, ServerResponse response) throws IOException, URISyntaxException {
        String welcomeFileResource;
        URL welcomeUrl;
        String resource = requestedPath.isEmpty() ? this.root : this.rootWithTrailingSlash + requestedPath;
        LOGGER.finest(() -> "Requested class path resource: " + resource);
        URI myuri = new URI(null, null, resource, null);
        String requestedResource = myuri.normalize().getPath();
        if (!requestedResource.equals(this.root) && !requestedResource.startsWith(this.rootWithTrailingSlash)) {
            return false;
        }
        URL url = this.classLoader.getResource(resource);
        String welcomeFileName = this.welcomePageName();
        if (null != welcomeFileName && null != (welcomeUrl = this.classLoader.getResource(welcomeFileResource = requestedResource + "/" + welcomeFileName))) {
            String rawFullPath = request.uri().getRawPath();
            if (rawFullPath.endsWith("/")) {
                url = welcomeUrl;
            } else {
                ClassPathContentHandler.redirect(response, rawFullPath + "/");
                return true;
            }
        }
        if (url == null) {
            LOGGER.fine(() -> "Requested resource " + resource + " does not exist");
            return false;
        }
        URL logUrl = url;
        LOGGER.finest(() -> "Located resource url. Resource: " + resource + ", URL: " + String.valueOf(logUrl));
        switch (url.getProtocol()) {
            case "file": {
                FileSystemContentHandler.sendFile(method, Paths.get(url.toURI()), request, response, this.contentTypeSelector(), this.welcomePageName());
                break;
            }
            case "jar": {
                return this.sendJar(method, requestedResource, url, request, response);
            }
            default: {
                this.sendUrlStream(method, url, request, response);
            }
        }
        return true;
    }

    boolean sendJar(Http.RequestMethod method, String requestedResource, URL url, ServerRequest request, ServerResponse response) {
        LOGGER.fine(() -> "Sending static content from classpath: " + String.valueOf(url));
        ExtractedJarEntry extrEntry = this.extracted.compute(requestedResource, (key, entry) -> this.existOrCreate(url, (ExtractedJarEntry)entry));
        if (extrEntry.tempFile == null) {
            return false;
        }
        if (extrEntry.lastModified != null) {
            ClassPathContentHandler.processEtag(String.valueOf(extrEntry.lastModified.toEpochMilli()), request.headers(), response.headers());
            ClassPathContentHandler.processModifyHeaders(extrEntry.lastModified, request.headers(), response.headers());
        }
        String entryName = extrEntry.entryName == null ? ClassPathContentHandler.fileName(url) : extrEntry.entryName;
        ClassPathContentHandler.processContentType(entryName, request.headers(), response.headers(), this.contentTypeSelector());
        if (method == Http.Method.HEAD) {
            response.send();
        } else {
            FileSystemContentHandler.send(response, extrEntry.tempFile);
        }
        return true;
    }

    private ExtractedJarEntry existOrCreate(URL url, ExtractedJarEntry entry) {
        if (entry == null) {
            return this.extractJarEntry(url);
        }
        if (entry.tempFile == null) {
            return entry;
        }
        if (Files.notExists(entry.tempFile, new LinkOption[0])) {
            return this.extractJarEntry(url);
        }
        return entry;
    }

    private void sendUrlStream(Http.RequestMethod method, URL url, ServerRequest request, ServerResponse response) throws IOException {
        LOGGER.finest(() -> "Sending static content using stream from classpath: " + String.valueOf(url));
        URLConnection urlConnection = url.openConnection();
        long lastModified = urlConnection.getLastModified();
        if (lastModified != 0L) {
            ClassPathContentHandler.processEtag(String.valueOf(lastModified), request.headers(), response.headers());
            ClassPathContentHandler.processModifyHeaders(Instant.ofEpochMilli(lastModified), request.headers(), response.headers());
        }
        ClassPathContentHandler.processContentType(ClassPathContentHandler.fileName(url), request.headers(), response.headers(), this.contentTypeSelector());
        if (method == Http.Method.HEAD) {
            response.send();
            return;
        }
        InputStream in = url.openStream();
        response.send((Flow.Publisher<DataChunk>)IoMulti.multiFromStreamBuilder((InputStream)in).byteBufferSize(2048).build().map(DataChunk::create));
    }

    static String fileName(URL url) {
        String path = url.getPath();
        int index = path.lastIndexOf(47);
        if (index > -1) {
            return path.substring(index + 1);
        }
        return path;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ExtractedJarEntry extractJarEntry(URL url) {
        try {
            JarURLConnection jarUrlConnection = (JarURLConnection)url.openConnection();
            JarFile jarFile = jarUrlConnection.getJarFile();
            JarEntry jarEntry = jarUrlConnection.getJarEntry();
            if (jarEntry.isDirectory()) {
                return new ExtractedJarEntry(jarEntry.getName());
            }
            Instant lastModified = this.getLastModified(jarFile.getName());
            try {
                ExtractedJarEntry extractedJarEntry;
                block13: {
                    InputStream is = jarFile.getInputStream(jarEntry);
                    try {
                        Path tempFile = this.createTempFile("ws", ".je");
                        Files.copy(is, tempFile, StandardCopyOption.REPLACE_EXISTING);
                        extractedJarEntry = new ExtractedJarEntry(tempFile, lastModified, jarEntry.getName());
                        if (is == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return extractedJarEntry;
            }
            finally {
                if (!jarUrlConnection.getUseCaches()) {
                    jarFile.close();
                }
            }
        }
        catch (IOException ioe) {
            throw new HttpException("Cannot load JAR file!", (Http.ResponseStatus)Http.Status.INTERNAL_SERVER_ERROR_500, ioe);
        }
    }

    private Path createTempFile(String prefix, String suffix) throws IOException {
        if (this.tempDir != null) {
            return Files.createTempFile(this.tempDir, prefix, suffix, new FileAttribute[0]);
        }
        return Files.createTempFile(prefix, suffix, new FileAttribute[0]);
    }

    private Instant getLastModified(String path) throws IOException {
        Path file = Paths.get(path, new String[0]);
        if (Files.exists(file, new LinkOption[0]) && Files.isRegularFile(file, new LinkOption[0])) {
            return Files.getLastModifiedTime(file, new LinkOption[0]).toInstant();
        }
        return null;
    }

    private static class ExtractedJarEntry {
        private final Path tempFile;
        private final Instant lastModified;
        private final String entryName;

        ExtractedJarEntry(Path tempFile, Instant lastModified, String entryName) {
            this.tempFile = tempFile;
            this.lastModified = lastModified;
            this.entryName = entryName;
        }

        ExtractedJarEntry(String entryName) {
            this.tempFile = null;
            this.lastModified = null;
            this.entryName = entryName;
        }
    }
}

