/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.DisplayableLabeledSnapshot;
import io.helidon.metrics.Sample;
import org.eclipse.microprofile.metrics.Snapshot;

class WrappedSnapshot
implements DisplayableLabeledSnapshot {
    private final Snapshot delegate;
    private final Sample.Labeled[] samples;
    private final Sample.Derived median;
    private final Sample.Labeled max;
    private final Sample.Labeled min;
    private final Sample.Derived mean;
    private final Sample.Derived stdDev;
    private final Sample.Derived sample75th;
    private final Sample.Derived sample95th;
    private final Sample.Derived sample98th;
    private final Sample.Derived sample99th;
    private final Sample.Derived sample999th;

    static WrappedSnapshot create(Snapshot delegate) {
        return new WrappedSnapshot(delegate);
    }

    private WrappedSnapshot(Snapshot delegate) {
        this.delegate = delegate;
        long[] values = delegate.getValues();
        this.samples = new Sample.Labeled[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.samples[i] = Sample.labeled(values[i]);
        }
        this.median = Sample.derived(delegate.getMedian());
        this.max = Sample.labeled(delegate.getMax());
        this.min = Sample.labeled(delegate.getMin());
        this.mean = Sample.derived(delegate.getMean());
        this.stdDev = Sample.derived(delegate.getStdDev());
        this.sample75th = Sample.derived(delegate.get75thPercentile());
        this.sample95th = Sample.derived(delegate.get95thPercentile());
        this.sample98th = Sample.derived(delegate.get98thPercentile());
        this.sample99th = Sample.derived(delegate.get99thPercentile());
        this.sample999th = Sample.derived(delegate.get999thPercentile());
    }

    @Override
    public Sample.Derived value(double quantile) {
        return Sample.derived(this.delegate.getValue(quantile));
    }

    @Override
    public Sample.Derived median() {
        return this.median;
    }

    @Override
    public Sample.Derived sample75thPercentile() {
        return this.sample75th;
    }

    @Override
    public Sample.Derived sample95thPercentile() {
        return this.sample95th;
    }

    @Override
    public Sample.Derived sample98thPercentile() {
        return this.sample98th;
    }

    @Override
    public Sample.Derived sample99thPercentile() {
        return this.sample99th;
    }

    @Override
    public Sample.Derived sample999thPercentile() {
        return this.sample999th;
    }

    @Override
    public Sample.Labeled max() {
        return this.max;
    }

    @Override
    public Sample.Derived mean() {
        return this.mean;
    }

    @Override
    public Sample.Labeled min() {
        return this.min;
    }

    @Override
    public Sample.Derived stdDev() {
        return this.stdDev;
    }
}

