/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.DisplayableLabeledSnapshot;
import io.helidon.metrics.Sample;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.microprofile.metrics.Snapshot;

class WeightedSnapshot
extends Snapshot
implements DisplayableLabeledSnapshot {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final WeightedSample[] copy;
    private long[] values = null;
    private final double[] normWeights;
    private final double[] quantiles;

    WeightedSnapshot(Collection<WeightedSample> values) {
        int i;
        this.copy = values.toArray(new WeightedSample[0]);
        Arrays.sort(this.copy, Comparator.comparing(WeightedSample::getValue));
        this.normWeights = new double[this.copy.length];
        this.quantiles = new double[this.copy.length];
        double sumWeight = 0.0;
        for (WeightedSample sample : this.copy) {
            sumWeight += sample.weight;
        }
        for (i = 0; i < this.copy.length; ++i) {
            this.normWeights[i] = sumWeight != 0.0 ? this.copy[i].weight / sumWeight : 0.0;
        }
        for (i = 1; i < this.copy.length; ++i) {
            this.quantiles[i] = this.quantiles[i - 1] + this.normWeights[i - 1];
        }
    }

    public double getValue(double quantile) {
        return this.value(quantile).value();
    }

    @Override
    public Sample.Derived value(double quantile) {
        int posx = this.slot(quantile);
        return posx == -1 ? Sample.Derived.ZERO : Sample.derived(this.copy[posx].value(), this.copy[posx]);
    }

    int slot(double quantile) {
        if (quantile < 0.0 || quantile > 1.0 || Double.isNaN(quantile)) {
            throw new IllegalArgumentException(quantile + " is not in [0..1]");
        }
        if (this.copy.length == 0) {
            return -1;
        }
        int posx = Arrays.binarySearch(this.quantiles, quantile);
        if (posx < 0) {
            posx = -posx - 1 - 1;
        }
        if (posx < 1) {
            return 0;
        }
        if (posx >= this.copy.length) {
            return this.copy.length - 1;
        }
        return posx;
    }

    public int size() {
        return this.copy.length;
    }

    public long[] getValues() {
        if (this.values == null) {
            long[] result = new long[this.copy.length];
            int i = 0;
            for (WeightedSample sample : this.copy) {
                result[i++] = sample.value();
            }
            this.values = result;
        }
        return this.values;
    }

    @Override
    public Sample.Derived median() {
        return this.value(0.5);
    }

    @Override
    public Sample.Derived sample75thPercentile() {
        return this.value(0.75);
    }

    @Override
    public Sample.Derived sample95thPercentile() {
        return this.value(0.95);
    }

    @Override
    public Sample.Derived sample98thPercentile() {
        return this.value(0.98);
    }

    @Override
    public Sample.Derived sample99thPercentile() {
        return this.value(0.99);
    }

    @Override
    public Sample.Derived sample999thPercentile() {
        return this.value(0.999);
    }

    public long getMax() {
        return this.max().value();
    }

    @Override
    public WeightedSample max() {
        return this.copy.length == 0 ? WeightedSample.ZERO : this.copy[this.copy.length - 1];
    }

    public long getMin() {
        return this.min().value();
    }

    @Override
    public WeightedSample min() {
        return this.copy.length == 0 ? WeightedSample.ZERO : this.copy[0];
    }

    public double getMean() {
        return this.mean().value();
    }

    @Override
    public Sample.Derived mean() {
        if (this.copy.length == 0) {
            return Sample.Derived.ZERO;
        }
        double sum = 0.0;
        for (int i = 0; i < this.copy.length; ++i) {
            sum += (double)this.copy[i].value() * this.normWeights[i];
        }
        int slot = this.slotNear(sum);
        return Sample.derived(sum, this.copy[slot]);
    }

    int slotNear(double value) {
        return WeightedSnapshot.slotNear(Sample.derived(value), this.copy);
    }

    static int slotNear(Sample target, Sample[] values) {
        int slot = Arrays.binarySearch(values, target, Comparator.comparingDouble(Sample::doubleValue));
        if (slot >= 0) {
            return slot;
        }
        if (-slot - 1 == values.length) {
            return values.length - 1;
        }
        if (slot == -1) {
            return 0;
        }
        int higherSlot = -slot - 1;
        double value = target.doubleValue();
        return values[higherSlot].doubleValue() - value < value - values[higherSlot - 1].doubleValue() ? higherSlot : higherSlot - 1;
    }

    public double getStdDev() {
        return this.stdDev().value();
    }

    @Override
    public Sample.Derived stdDev() {
        if (this.copy.length <= 1) {
            return Sample.Derived.ZERO;
        }
        double mean = this.mean().value();
        double variance = 0.0;
        for (int i = 0; i < this.copy.length; ++i) {
            double diff = (double)this.copy[i].value() - mean;
            variance += this.normWeights[i] * diff * diff;
        }
        return Sample.derived(Math.sqrt(variance));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(OutputStream output) {
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter(output, UTF_8));){
            for (WeightedSample sample : this.copy) {
                out.printf("%d,%l,%s%n", sample.value(), sample.weight, sample.label());
            }
        }
    }

    static class WeightedSample
    extends Sample.Labeled.Impl {
        static final WeightedSample ZERO = new WeightedSample(0L, 1.0, "");
        private final double weight;

        WeightedSample(long value, double weight, long timestamp, String label) {
            super(value, label, timestamp);
            this.weight = weight;
        }

        WeightedSample(long value, double weight, String label) {
            this(value, weight, label.isEmpty() ? 0L : System.currentTimeMillis(), label);
        }

        WeightedSample(long value) {
            this(value, 1.0, 0L, "");
        }

        long getValue() {
            return this.value();
        }

        double getWeight() {
            return this.weight;
        }
    }
}

