/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

class PeriodicExecutor {
    static final PeriodicExecutor INSTANCE = PeriodicExecutor.create();
    private static final Logger LOGGER = Logger.getLogger(PeriodicExecutor.class.getName());
    private static final String STOP_LOG_MESSAGE = "Received stop request in state {0}";
    private volatile State state = State.DORMANT;
    private ScheduledExecutorService currentTimeUpdaterExecutorService;
    private final Collection<Enrollment> deferredEnrollments = new ArrayList<Enrollment>();
    private final Semaphore access = new Semaphore(1, true);

    static PeriodicExecutor create() {
        return new PeriodicExecutor();
    }

    private PeriodicExecutor() {
    }

    static void enroll(Runnable runnable, Duration interval) {
        INSTANCE.enrollRunner(runnable, interval);
    }

    static void start() {
        INSTANCE.startExecutor();
    }

    static void stop() {
        INSTANCE.stopExecutor();
    }

    static State state() {
        return INSTANCE.executorState();
    }

    void enrollRunner(Runnable runnable, Duration interval) {
        this.sync("enroll runner", () -> {
            if (this.state == State.STARTED) {
                this.currentTimeUpdaterExecutorService.scheduleAtFixedRate(runnable, interval.toMillis(), interval.toMillis(), TimeUnit.MILLISECONDS);
            } else {
                this.deferredEnrollments.add(new Enrollment(runnable, interval));
                if (this.state == State.STOPPED) {
                    LOGGER.log(Level.FINE, "Recording deferred enrollment even though in unexpected state " + String.valueOf((Object)State.STOPPED), new IllegalStateException());
                }
            }
        });
    }

    void startExecutor() {
        this.sync("start", () -> {
            if (this.state.isStartable()) {
                LOGGER.log(Level.FINE, "Starting up with " + this.deferredEnrollments.size() + " deferred enrollments" + (String)(this.state == State.DORMANT ? "" : " even though in state " + String.valueOf((Object)this.state)));
                this.state = State.STARTED;
                this.currentTimeUpdaterExecutorService = Executors.newSingleThreadScheduledExecutor();
                for (Enrollment deferredEnrollment : this.deferredEnrollments) {
                    this.currentTimeUpdaterExecutorService.scheduleAtFixedRate(deferredEnrollment.runnable, deferredEnrollment.interval.toMillis(), deferredEnrollment.interval.toMillis(), TimeUnit.MILLISECONDS);
                }
                this.deferredEnrollments.clear();
            } else {
                LOGGER.log(Level.WARNING, String.format("Attempt to start in unexpected state state %s; ignored", new Object[]{this.state}), new IllegalStateException());
            }
        });
    }

    void stopExecutor() {
        this.sync("stop", () -> {
            LOGGER.log(Level.FINE, STOP_LOG_MESSAGE, (Object)this.state);
            switch (this.state) {
                case STARTED: {
                    this.currentTimeUpdaterExecutorService.shutdownNow();
                    break;
                }
                case DORMANT: {
                    break;
                }
                default: {
                    LOGGER.log(Level.FINE, String.format("Unexpected attempt to stop; the expected states are %s but found %s; ignored", new Object[]{Set.of(State.DORMANT, State.STARTED), this.state}), new IllegalStateException());
                }
            }
            this.state = State.STOPPED;
        });
    }

    State executorState() {
        return this.state;
    }

    private void sync(String taskDescription, Runnable task) {
        try {
            this.access.acquire();
            task.run();
            this.access.release();
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.WARNING, "Attempt to " + taskDescription + " failed", ex);
        }
    }

    private static class Enrollment {
        private final Runnable runnable;
        private final Duration interval;

        Enrollment(Runnable runnable, Duration interval) {
            this.runnable = runnable;
            this.interval = interval;
        }
    }

    static enum State {
        DORMANT,
        STARTED,
        STOPPED;


        boolean isStartable() {
            return this != STARTED;
        }
    }
}

