/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.Clock;
import io.helidon.metrics.DisplayableLabeledSnapshot;
import io.helidon.metrics.HelidonHistogram;
import io.helidon.metrics.HelidonMeter;
import io.helidon.metrics.MetricImpl;
import io.helidon.metrics.PrometheusName;
import io.helidon.metrics.WrappedSnapshot;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.json.JsonObjectBuilder;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Timer;

final class HelidonTimer
extends MetricImpl
implements Timer {
    private final Timer delegate;

    private HelidonTimer(String type, Metadata metadata, Timer delegate) {
        super(type, metadata);
        this.delegate = delegate;
    }

    static HelidonTimer create(String repoType, Metadata metadata) {
        return HelidonTimer.create(repoType, metadata, Clock.system());
    }

    static HelidonTimer create(String repoType, Metadata metadata, Clock clock) {
        return HelidonTimer.create(repoType, metadata, new TimerImpl(repoType, metadata.getName(), clock));
    }

    static HelidonTimer create(String repoType, Metadata metadata, Timer metric) {
        return new HelidonTimer(repoType, metadata, metric);
    }

    public void update(long duration, TimeUnit unit) {
        this.delegate.update(duration, unit);
    }

    public <T> T time(Callable<T> event) throws Exception {
        return (T)this.delegate.time(event);
    }

    public void time(Runnable event) {
        this.delegate.time(event);
    }

    public Timer.Context time() {
        return this.delegate.time();
    }

    public long getCount() {
        return this.delegate.getCount();
    }

    public double getFifteenMinuteRate() {
        return this.delegate.getFifteenMinuteRate();
    }

    public double getFiveMinuteRate() {
        return this.delegate.getFiveMinuteRate();
    }

    public double getMeanRate() {
        return this.delegate.getMeanRate();
    }

    public double getOneMinuteRate() {
        return this.delegate.getOneMinuteRate();
    }

    public Snapshot getSnapshot() {
        return this.delegate.getSnapshot();
    }

    DisplayableLabeledSnapshot snapshot() {
        return this.delegate instanceof TimerImpl ? ((TimerImpl)this.delegate).histogram.snapshot() : WrappedSnapshot.create(this.delegate.getSnapshot());
    }

    @Override
    public void prometheusData(StringBuilder sb, MetricID metricID, boolean withHelpType, boolean isStrictExemplars) {
        PrometheusName name = PrometheusName.create(this, metricID, MetricImpl.TimeUnits.PROMETHEUS_TIMER_CONVERSION_TIME_UNITS);
        this.appendPrometheusTimerStatElement(sb, name, "rate_per_second", withHelpType, "gauge", this.getMeanRate());
        this.appendPrometheusTimerStatElement(sb, name, "one_min_rate_per_second", withHelpType, "gauge", this.getOneMinuteRate());
        this.appendPrometheusTimerStatElement(sb, name, "five_min_rate_per_second", withHelpType, "gauge", this.getFiveMinuteRate());
        this.appendPrometheusTimerStatElement(sb, name, "fifteen_min_rate_per_second", withHelpType, "gauge", this.getFifteenMinuteRate());
        DisplayableLabeledSnapshot snap = this.snapshot();
        this.appendPrometheusHistogramElements(sb, name, MetricImpl.TimeUnits.PROMETHEUS_TIMER_CONVERSION_TIME_UNITS, withHelpType, this.getCount(), snap, isStrictExemplars);
    }

    @Override
    public String prometheusValue() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void jsonData(JsonObjectBuilder builder, MetricID metricID) {
        JsonObjectBuilder myBuilder = JSON.createObjectBuilder().add(HelidonTimer.jsonFullKey("count", metricID), this.getCount()).add(HelidonTimer.jsonFullKey("meanRate", metricID), this.getMeanRate()).add(HelidonTimer.jsonFullKey("oneMinRate", metricID), this.getOneMinuteRate()).add(HelidonTimer.jsonFullKey("fiveMinRate", metricID), this.getFiveMinuteRate()).add(HelidonTimer.jsonFullKey("fifteenMinRate", metricID), this.getFifteenMinuteRate());
        Snapshot snapshot = this.getSnapshot();
        long divisor = this.conversionFactor();
        myBuilder = myBuilder.add(HelidonTimer.jsonFullKey("min", metricID), snapshot.getMin() / divisor).add(HelidonTimer.jsonFullKey("max", metricID), snapshot.getMax() / divisor).add(HelidonTimer.jsonFullKey("mean", metricID), snapshot.getMean() / (double)divisor).add(HelidonTimer.jsonFullKey("stddev", metricID), snapshot.getStdDev() / (double)divisor).add(HelidonTimer.jsonFullKey("p50", metricID), snapshot.getMedian() / (double)divisor).add(HelidonTimer.jsonFullKey("p75", metricID), snapshot.get75thPercentile() / (double)divisor).add(HelidonTimer.jsonFullKey("p95", metricID), snapshot.get95thPercentile() / (double)divisor).add(HelidonTimer.jsonFullKey("p98", metricID), snapshot.get98thPercentile() / (double)divisor).add(HelidonTimer.jsonFullKey("p99", metricID), snapshot.get99thPercentile() / (double)divisor).add(HelidonTimer.jsonFullKey("p999", metricID), snapshot.get999thPercentile() / (double)divisor);
        builder.add(metricID.getName(), myBuilder);
    }

    void appendPrometheusTimerStatElement(StringBuilder sb, PrometheusName name, String statName, boolean withHelpType, String typeName, double value) {
        if (withHelpType) {
            this.prometheusType(sb, name.nameStat(statName), typeName);
        }
        sb.append(name.nameStat(statName)).append(" ").append(value).append("\n");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        HelidonTimer that = (HelidonTimer)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delegate);
    }

    @Override
    protected String toStringDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append(", count='").append(this.getCount()).append('\'');
        sb.append(", fifteenMinuteRate='").append(this.getFifteenMinuteRate()).append('\'');
        sb.append(", fiveMinuteRate='").append(this.getFiveMinuteRate()).append('\'');
        sb.append(", meanRate='").append(this.getMeanRate()).append('\'');
        return sb.toString();
    }

    private static class TimerImpl
    implements Timer {
        private final Meter meter;
        private final HelidonHistogram histogram;
        private final Clock clock;

        TimerImpl(String repoType, String name, Clock clock) {
            this.meter = HelidonMeter.create(repoType, Metadata.builder().withName(name).withType(MetricType.METERED).build(), clock);
            this.histogram = HelidonHistogram.create(repoType, Metadata.builder().withName(name).withType(MetricType.HISTOGRAM).build(), clock);
            this.clock = clock;
        }

        public void update(long duration, TimeUnit unit) {
            this.update(unit.toNanos(duration));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T time(Callable<T> event) throws Exception {
            long t = this.clock.nanoTick();
            try {
                T t2 = event.call();
                return t2;
            }
            finally {
                this.update(this.clock.nanoTick() - t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void time(Runnable event) {
            long t = this.clock.nanoTick();
            try {
                event.run();
            }
            finally {
                this.update(this.clock.nanoTick() - t);
            }
        }

        public Timer.Context time() {
            return new ContextImpl(this, this.clock);
        }

        public long getCount() {
            return this.histogram.getCount();
        }

        public double getFifteenMinuteRate() {
            return this.meter.getFifteenMinuteRate();
        }

        public double getFiveMinuteRate() {
            return this.meter.getFiveMinuteRate();
        }

        public double getMeanRate() {
            return this.meter.getMeanRate();
        }

        public double getOneMinuteRate() {
            return this.meter.getOneMinuteRate();
        }

        public Snapshot getSnapshot() {
            return this.histogram.getSnapshot();
        }

        private void update(long nanos) {
            if (nanos >= 0L) {
                this.histogram.update(nanos);
                this.meter.mark();
            }
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.meter, this.histogram);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimerImpl that = (TimerImpl)o;
            return this.meter.equals(that.meter) && this.histogram.equals(that.histogram);
        }
    }

    private static final class ContextImpl
    implements Timer.Context {
        private final TimerImpl theTimer;
        private final long startTime;
        private final Clock clock;
        private final AtomicBoolean running = new AtomicBoolean(true);
        private long elapsed;

        private ContextImpl(TimerImpl theTimer, Clock clock) {
            this.theTimer = theTimer;
            this.startTime = clock.nanoTick();
            this.clock = clock;
        }

        public long stop() {
            if (this.running.compareAndSet(true, false)) {
                this.elapsed = this.clock.nanoTick() - this.startTime;
                this.theTimer.update(this.elapsed, TimeUnit.NANOSECONDS);
            }
            return this.elapsed;
        }

        public void close() {
            this.stop();
        }
    }
}

