/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.Clock;
import io.helidon.metrics.MetricImpl;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.json.JsonObjectBuilder;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;

final class HelidonConcurrentGauge
extends MetricImpl
implements ConcurrentGauge {
    private static final String PROMETHEUS_TYPE = "gauge";
    private final ConcurrentGauge delegate;

    private HelidonConcurrentGauge(String registryType, Metadata metadata, ConcurrentGauge delegate) {
        super(registryType, metadata);
        this.delegate = delegate;
    }

    static HelidonConcurrentGauge create(String registryType, Metadata metadata) {
        return HelidonConcurrentGauge.create(registryType, metadata, Clock.system());
    }

    static HelidonConcurrentGauge create(String registryType, Metadata metadata, Clock clock) {
        return HelidonConcurrentGauge.create(registryType, metadata, new ConcurrentGaugeImpl(clock));
    }

    static HelidonConcurrentGauge create(String registryType, Metadata metadata, ConcurrentGauge metric) {
        return new HelidonConcurrentGauge(registryType, metadata, metric);
    }

    public void inc() {
        this.delegate.inc();
    }

    public void dec() {
        this.delegate.dec();
    }

    public long getCount() {
        return this.delegate.getCount();
    }

    public long getMax() {
        return this.delegate.getMax();
    }

    public long getMin() {
        return this.delegate.getMin();
    }

    @Override
    public String prometheusNameWithUnits(MetricID metricID) {
        return this.prometheusName(metricID.getName());
    }

    @Override
    public String prometheusValue() {
        return Long.toString(this.getCount());
    }

    @Override
    public void jsonData(JsonObjectBuilder builder, MetricID metricID) {
        JsonObjectBuilder myBuilder = JSON.createObjectBuilder().add(HelidonConcurrentGauge.jsonFullKey("current", metricID), this.getCount()).add(HelidonConcurrentGauge.jsonFullKey("max", metricID), this.getMax()).add(HelidonConcurrentGauge.jsonFullKey("min", metricID), this.getMin());
        builder.add(metricID.getName(), myBuilder);
    }

    @Override
    public void prometheusData(StringBuilder sb, MetricID metricID, boolean withHelpType, boolean isStrictExemplar) {
        String name = this.prometheusNameWithUnits(metricID);
        String nameCurrent = name + "_current";
        if (withHelpType) {
            this.prometheusType(sb, nameCurrent, this.metadata().getType());
            this.prometheusHelp(sb, nameCurrent);
        }
        sb.append(nameCurrent).append(this.prometheusTags(metricID.getTags())).append(" ").append(this.prometheusValue()).append('\n');
        String nameMin = name + "_min";
        if (withHelpType) {
            this.prometheusType(sb, nameMin, this.metadata().getType());
        }
        sb.append(nameMin).append(this.prometheusTags(metricID.getTags())).append(" ").append(this.getMin()).append('\n');
        String nameMax = name + "_max";
        if (withHelpType) {
            this.prometheusType(sb, nameMax, this.metadata().getType());
        }
        sb.append(nameMax).append(this.prometheusTags(metricID.getTags())).append(" ").append(this.getMax()).append('\n');
    }

    @Override
    void prometheusType(StringBuilder sb, String nameWithUnits, String type) {
        super.prometheusType(sb, nameWithUnits, PROMETHEUS_TYPE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        HelidonConcurrentGauge that = (HelidonConcurrentGauge)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delegate);
    }

    @Override
    protected String toStringDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append(", count='").append(this.getCount()).append('\'');
        sb.append(", min='").append(this.getMin()).append('\'');
        sb.append(", max='").append(this.getMax()).append('\'');
        return sb.toString();
    }

    static class ConcurrentGaugeImpl
    implements ConcurrentGauge {
        private final AtomicLong count;
        private final AtomicLong lastMax;
        private final AtomicLong lastMin;
        private final AtomicLong currentMax;
        private final AtomicLong currentMin;
        private final AtomicLong lastMinute;
        private final Clock clock;

        ConcurrentGaugeImpl(Clock clock) {
            this.clock = clock;
            this.count = new AtomicLong(0L);
            this.lastMax = new AtomicLong(Long.MIN_VALUE);
            this.lastMin = new AtomicLong(Long.MAX_VALUE);
            this.currentMax = new AtomicLong(Long.MIN_VALUE);
            this.currentMin = new AtomicLong(Long.MAX_VALUE);
            this.lastMinute = new AtomicLong(this.currentTimeMinute());
        }

        public long getCount() {
            return this.count.get();
        }

        public long getMax() {
            this.updateState();
            long max = this.lastMax.get();
            return max == Long.MIN_VALUE ? 0L : max;
        }

        public long getMin() {
            this.updateState();
            long min = this.lastMin.get();
            return min == Long.MAX_VALUE ? 0L : min;
        }

        public synchronized void inc() {
            this.updateState();
            this.count.incrementAndGet();
            long count = this.getCount();
            if (count > this.currentMax.get()) {
                this.currentMax.set(count);
            }
        }

        public synchronized void dec() {
            this.updateState();
            this.count.decrementAndGet();
            long count = this.getCount();
            if (count < this.currentMin.get()) {
                this.currentMin.set(count);
            }
        }

        public synchronized void updateState() {
            long currentMinute = this.currentTimeMinute();
            long diff = currentMinute - this.lastMinute.get();
            if (diff >= 1L) {
                this.lastMax.set(this.currentMax.get());
                this.lastMin.set(this.currentMin.get());
                this.lastMinute.set(currentMinute);
            }
        }

        private long currentTimeMinute() {
            return this.clock.milliTime() / 1000L / 60L;
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.count, this.lastMin, this.lastMax);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConcurrentGaugeImpl that = (ConcurrentGaugeImpl)o;
            return this.count.equals(that.count) && this.lastMin.equals(that.lastMin) && this.lastMax.equals(that.lastMax);
        }
    }
}

