/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.common.LazyValue;
import io.helidon.common.configurable.spi.ExecutorServiceSupplierObserver;
import io.helidon.metrics.api.RegistryFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;

public class ExecutorServiceMetricsObserver
implements ExecutorServiceSupplierObserver {
    private static final Logger LOGGER = Logger.getLogger(ExecutorServiceMetricsObserver.class.getName());
    private static final String METRIC_NAME_PREFIX = "executor-service.";
    private static final List<GaugeFactory<?, ThreadPoolExecutor>> THREAD_POOL_EXECUTOR_METRIC_FACTORIES = List.of(GaugeFactory.create(MetadataTemplates.ACTIVE_COUNT_METADATA, ThreadPoolExecutor::getActiveCount), GaugeFactory.create(MetadataTemplates.COMPLETED_TASK_COUNT_METADATA, ThreadPoolExecutor::getCompletedTaskCount), GaugeFactory.create(MetadataTemplates.POOL_SIZE_METADATA, ThreadPoolExecutor::getPoolSize), GaugeFactory.create(MetadataTemplates.LARGEST_POOL_SIZE_METADATA, ThreadPoolExecutor::getLargestPoolSize), GaugeFactory.create(MetadataTemplates.TASK_COUNT_METADATA, ThreadPoolExecutor::getTaskCount), GaugeFactory.create(MetadataTemplates.QUEUE_REMAINING_CAPACITY_METADATA, tpe -> tpe.getQueue().remainingCapacity()), GaugeFactory.create(MetadataTemplates.QUEUE_SIZE_METADATA, tpe -> tpe.getQueue().size()));
    private final LazyValue<MetricRegistry> registry = LazyValue.create(() -> RegistryFactory.getInstance().getRegistry(MetricRegistry.Type.VENDOR));

    public ExecutorServiceSupplierObserver.SupplierObserverContext registerSupplier(Supplier<? extends ExecutorService> supplier, int supplierIndex, String supplierCategory) {
        SupplierInfo supplierInfo = new SupplierInfo(supplierCategory, supplierIndex);
        LOGGER.log(Level.FINE, () -> String.format("Metrics thread pool supplier registration: %s", supplierInfo));
        return supplierInfo.context();
    }

    public ExecutorServiceSupplierObserver.SupplierObserverContext registerSupplier(Supplier<? extends ExecutorService> supplier, int supplierIndex, String supplierCategory, List<ExecutorServiceSupplierObserver.MethodInvocation> methodInvocations) {
        SupplierInfoWithMethods supplierInfo = new SupplierInfoWithMethods(supplierCategory, supplierIndex, methodInvocations);
        LOGGER.log(Level.FINE, () -> String.format("Metrics thread pool supplier registration: %s", supplierInfo));
        return supplierInfo.context();
    }

    private static Tag[] tags(String supplierCategory, int supplierIndex, int index) {
        return new Tag[]{new Tag("supplierCategory", supplierCategory), new Tag("supplierIndex", Integer.toString(supplierIndex)), new Tag("poolIndex", Integer.toString(index))};
    }

    private static class GaugeFactory<T, E extends ExecutorService> {
        private final Metadata templateMetadata;
        private final Function<E, T> valueFunction;

        private static <T, E extends ExecutorService> GaugeFactory<T, E> create(Metadata templateMetadata, Function<E, T> valueFunction) {
            return new GaugeFactory<T, E>(templateMetadata, valueFunction);
        }

        private GaugeFactory(Metadata templateMetadata, Function<E, T> valueFunction) {
            this.templateMetadata = templateMetadata;
            this.valueFunction = valueFunction;
        }

        private Gauge<T> registerGauge(MetricRegistry registry, String supplierCategory, int supplierIndex, E executor, int index, Set<MetricID> metricIDs) {
            Tag[] tags = ExecutorServiceMetricsObserver.tags(supplierCategory, supplierIndex, index);
            metricIDs.add(new MetricID(this.templateMetadata.getName(), tags));
            return (Gauge)registry.register(this.templateMetadata, (Metric)((Gauge)() -> this.valueFunction.apply(executor)), tags);
        }
    }

    private static class MetadataTemplates {
        private static final Metadata ACTIVE_COUNT_METADATA = Metadata.builder().withName("executor-service.active-count").withDescription("Active count").withType(MetricType.GAUGE).withUnit("none").build();
        private static final Metadata COMPLETED_TASK_COUNT_METADATA = Metadata.builder().withName("executor-service.completed-task-count").withDescription("Completed task count").withType(MetricType.GAUGE).withUnit("none").build();
        private static final Metadata POOL_SIZE_METADATA = Metadata.builder().withName("executor-service.pool-size").withDescription("Pool size").withType(MetricType.GAUGE).withUnit("none").build();
        private static final Metadata LARGEST_POOL_SIZE_METADATA = Metadata.builder().withName("executor-service.largest-pool-size").withDescription("Largest pool size").withType(MetricType.GAUGE).withUnit("none").build();
        private static final Metadata TASK_COUNT_METADATA = Metadata.builder().withName("executor-service.task-count").withDescription("Task count").withType(MetricType.GAUGE).withUnit("none").build();
        private static final Metadata QUEUE_REMAINING_CAPACITY_METADATA = Metadata.builder().withName("executor-service.queue.remaining-capacity").withDescription("Queue remaining capacity").withType(MetricType.GAUGE).withUnit("none").build();
        private static final Metadata QUEUE_SIZE_METADATA = Metadata.builder().withName("executor-service.queue.size").withDescription("Queue size").withType(MetricType.GAUGE).withUnit("none").build();

        private MetadataTemplates() {
        }
    }

    private class SupplierInfoWithMethods
    extends SupplierInfo {
        private final List<ExecutorServiceSupplierObserver.MethodInvocation> methodInvocations;

        private SupplierInfoWithMethods(String supplierCategory, int supplierIndex, List<ExecutorServiceSupplierObserver.MethodInvocation> methodInvocations) {
            super(supplierCategory, supplierIndex);
            this.methodInvocations = methodInvocations;
        }

        private List<ExecutorServiceSupplierObserver.MethodInvocation> methodInvocations() {
            return this.methodInvocations;
        }

        @Override
        public String toString() {
            return new StringJoiner(", ", SupplierInfoWithMethods.class.getSimpleName() + "[", "]").add("supplierCategory='" + this.supplierCategory() + "'").add("supplierIndex=" + this.supplierIndex()).add("methodInvocations=" + String.valueOf(this.methodInvocations)).toString();
        }
    }

    private class SupplierInfo {
        private final MetricsObserverContext context;
        private final String supplierCategory;
        private final int supplierIndex;

        private SupplierInfo(String supplierCategory, int supplierIndex) {
            this.supplierCategory = supplierCategory;
            this.supplierIndex = supplierIndex;
            this.context = new MetricsObserverContext(this);
        }

        String supplierCategory() {
            return this.supplierCategory;
        }

        int supplierIndex() {
            return this.supplierIndex;
        }

        private MetricsObserverContext context() {
            return this.context;
        }

        public String toString() {
            return new StringJoiner(", ", SupplierInfo.class.getSimpleName() + "[", "]").add("supplierCategory='" + this.supplierCategory + "'").add("supplierIndex=" + this.supplierIndex).toString();
        }
    }

    private class MetricsObserverContext
    implements ExecutorServiceSupplierObserver.SupplierObserverContext {
        private final SupplierInfo supplierInfo;
        private final Set<MetricID> metricsIDs = new HashSet<MetricID>();

        private MetricsObserverContext(SupplierInfo supplierInfo) {
            this.supplierInfo = supplierInfo;
        }

        public void registerExecutorService(ExecutorService executorService, int index) {
            LOGGER.log(Level.FINE, String.format("Registering executor service %s:%d for supplier %s%d", executorService, index, this.supplierInfo.supplierCategory(), this.supplierInfo.supplierIndex()));
            if (executorService instanceof ThreadPoolExecutor) {
                this.registerMetrics((ThreadPoolExecutor)executorService, index);
            } else if (this.supplierInfo instanceof SupplierInfoWithMethods) {
                this.registerMetrics(executorService, ((SupplierInfoWithMethods)this.supplierInfo).methodInvocations(), index);
            }
        }

        private void registerMetrics(ThreadPoolExecutor threadPoolExecutor, int index) {
            THREAD_POOL_EXECUTOR_METRIC_FACTORIES.forEach(factory -> factory.registerGauge((MetricRegistry)ExecutorServiceMetricsObserver.this.registry.get(), this.supplierInfo.supplierCategory(), this.supplierInfo.supplierIndex(), threadPoolExecutor, index, this.metricsIDs));
        }

        private void registerMetrics(ExecutorService executorService, List<ExecutorServiceSupplierObserver.MethodInvocation> methodInvocations, int index) {
            methodInvocations.forEach(mi -> {
                Metadata metadata = Metadata.builder().withName(ExecutorServiceMetricsObserver.METRIC_NAME_PREFIX + mi.displayName()).withDescription(mi.description()).withType(MetricType.GAUGE).withUnit("none").build();
                Tag[] tags = ExecutorServiceMetricsObserver.tags(this.supplierInfo.supplierCategory(), this.supplierInfo.supplierIndex(), index);
                ((MetricRegistry)ExecutorServiceMetricsObserver.this.registry.get()).register(metadata, (Metric)((Gauge)() -> {
                    try {
                        return mi.method().invoke((Object)executorService, new Object[0]);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }), tags);
                this.metricsIDs.add(new MetricID(metadata.getName(), tags));
            });
        }

        public void unregisterExecutorService(ExecutorService executorService) {
            this.metricsIDs.forEach(metricID -> ((MetricRegistry)ExecutorServiceMetricsObserver.this.registry.get()).remove(metricID));
        }
    }
}

