/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.util.Date;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import weblogic.remoteconsole.server.repo.Frontend;
import weblogic.remoteconsole.server.repo.InvocationContext;

public class WebAppUtils {
    public static final String CONSOLE_BACKEND_COOKIE = "WebLogicRemoteConsoleSessionID";
    public static final String CONSOLE_BACKEND_COOKIE_PATH = "/api";
    private static boolean useTokenNotCookie;

    public static InvocationContext getInvocationContextFromResourceContext(ResourceContext resourceContext) {
        ContainerRequestContext requestContext = (ContainerRequestContext)resourceContext.getResource(ContainerRequestContext.class);
        return requestContext != null ? WebAppUtils.getInvocationContextFromRequestContext(requestContext) : null;
    }

    public static void setUseTokenNotCookie() {
        useTokenNotCookie = true;
    }

    public static InvocationContext getInvocationContextFromRequestContext(ContainerRequestContext requestContext) {
        return (InvocationContext)requestContext.getProperty(InvocationContext.class.getName());
    }

    public static void storeInvocationContextInRequestContext(ContainerRequestContext requestContext, InvocationContext ic) {
        requestContext.setProperty(InvocationContext.class.getName(), (Object)ic);
    }

    public static Response.ResponseBuilder addCookieFromContext(ResourceContext context, Response.ResponseBuilder response) {
        ContainerRequestContext requestContext = (ContainerRequestContext)context.getResource(ContainerRequestContext.class);
        return WebAppUtils.addCookieFromRequestContext(requestContext, response);
    }

    public static Response.ResponseBuilder addCookieFromRequestContext(ContainerRequestContext requestContext, Response.ResponseBuilder response) {
        NewCookie cookie = (NewCookie)requestContext.getProperty(NewCookie.class.getName());
        if (cookie != null) {
            if (useTokenNotCookie) {
                response.header("X-Session-Token", (Object)cookie.toCookie().getValue());
            } else {
                response.cookie(new NewCookie[]{cookie});
            }
        }
        return response;
    }

    public static void storeCookieInContext(ContainerRequestContext requestContext, Frontend frontend) {
        Date expiry = null;
        int maxAge = -1;
        boolean secure = requestContext.getSecurityContext().isSecure();
        Object value = frontend.getID();
        if (frontend.isSameSiteCookieEnabled()) {
            value = (String)value + ";SameSite=" + frontend.getValueSameSiteCookie();
        }
        requestContext.setProperty(NewCookie.class.getName(), (Object)new NewCookie(CONSOLE_BACKEND_COOKIE, (String)value, CONSOLE_BACKEND_COOKIE_PATH, null, 1, null, maxAge, expiry, secure, true));
    }
}

