/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import weblogic.console.utils.Path;
import weblogic.remoteconsole.common.repodef.PagePath;
import weblogic.remoteconsole.common.utils.UrlUtils;
import weblogic.remoteconsole.server.repo.InvocationContext;

public class UriUtils {
    public static final String API_URI = "api";

    private UriUtils() {
    }

    public static String getBackendRelativePDJUri(InvocationContext ic, PagePath pagePath) {
        Path connectionRelativePath = new Path();
        String pageRepoName = ic.getPageRepo().getPageRepoDef().getName();
        connectionRelativePath.addComponent(pageRepoName);
        connectionRelativePath.addComponent("pages");
        return UriUtils.getBackendRelativeUri(ic, connectionRelativePath) + "/" + pagePath.getPDJUri();
    }

    public static String getBackendRelativeUri(InvocationContext ic, Path connectionRelativePath) {
        return "/" + UrlUtils.pathToRelativeUri(UriUtils.getBackendRelativePath(ic, connectionRelativePath));
    }

    private static Path getBackendRelativePath(InvocationContext ic, Path connectionRelativePath) {
        Path path = new Path();
        path.addComponent(API_URI);
        path.addComponent(UrlUtils.urlEncode(ic.getProvider().getName()));
        path.addPath(connectionRelativePath);
        return path;
    }
}

