/*
 * Decompiled with CFR 0.152.
 */
package weblogic.remoteconsole.server.webapp;

import java.util.ArrayList;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import weblogic.remoteconsole.server.repo.BeanTreePath;
import weblogic.remoteconsole.server.repo.InvocationContext;
import weblogic.remoteconsole.server.repo.Response;
import weblogic.remoteconsole.server.webapp.RequestBodyMapper;

public class TableActionRequestBodyMapper
extends RequestBodyMapper<List<BeanTreePath>> {
    private static final String ROWS = "rows";
    private static final String VALUE = "value";

    public static Response<List<BeanTreePath>> fromRequestBody(InvocationContext ic, JsonObject requestBody) {
        return new TableActionRequestBodyMapper(ic, requestBody).fromRequestBody();
    }

    private TableActionRequestBodyMapper(InvocationContext ic, JsonObject requestBody) {
        super(ic, requestBody);
    }

    @Override
    protected void parseRequestBody() {
        ArrayList<BeanTreePath> identities = new ArrayList<BeanTreePath>();
        JsonObject rows = this.getOptionalJsonObject(this.getRequestBody(), ROWS);
        if (this.isOK() && rows != null) {
            JsonArray values = this.getRequiredJsonArray(rows, VALUE);
            for (int i = 0; this.isOK() && i < values.size(); ++i) {
                JsonObject row = this.asJsonObject(VALUE, (JsonValue)values.get(i));
                if (!this.isOK()) continue;
                BeanTreePath btp = this.getRequiredBeanTreePath(row, VALUE);
                if (!this.isOK()) continue;
                identities.add(btp);
            }
        }
        if (this.isOK()) {
            this.getResponse().setSuccess(identities);
        }
    }
}

